<?php
function Slug($string)
{
    return substr((trim(preg_replace('~[^0-9a-z]+~i', '-', html_entity_decode(preg_replace('~&([a-z]{1,2})(?:acute|cedil|circ|grave|lig|orn|ring|slash|th|tilde|uml);~i', '$1', htmlentities($string, ENT_QUOTES, 'UTF-8')), ENT_QUOTES, 'UTF-8')), '-')),0,255);
}

class SugarPlum {
    protected $tableName;
    protected $debug = true;
    public $shopPath = '';
    public $authKey = '';
    // http://N7A4RMXPL46VI50FP1B9XSAY9A0ZNMLF@sugarplumoutlet.com/api

    function __construct($shopPath='', $auth=''){
        global $webService;
        $this->shopPath = $shopPath;
        $this->authKey = $auth;
        try {
            $webService = new PrestaShopWebservice(
                $this->shopPath,
                $this->authKey,
                false);
        }
        catch (PrestaShopWebserviceException $ex) {
            $trace = $ex->getTrace(); // Retrieve all information on the error
            $errorCode = $trace[0]['args'][0]; // Retrieve the error code
            if ($errorCode == 401) {
                echo 'Bad auth key';
            } else {
                echo 'Other error : <br />'.$ex->getMessage();
                // Shows a message related to the error
            }
        }
    }

    /*   function insertProduct(){
    global $webService;
    $opt = array('resource' => 'products');
    $xml = $webService->get(array('url' => $this->shopPath.'/api/products?schema=synopsis'));
    $resources = $xml->children()->children();
    unset($resources->position_in_category);
    unset($resources->manufacturer_name);
    $resources->price = '1000';
    $resources->active = '1';
    //$resources->quantity = '50';
    $resources->link_rewrite = 'blabla';
    $resources->name->language[0][0] = 'blabla';
    $resources->description->language[0][0] = '<p>blabla</p>';
    $resources->description_short->language[0][0] = 'blabla';
    $resources->associations = '';
    $opt = array('resource' => 'products');
    $opt['postXml'] = $xml->asXML();
    $xml = $webService->add($opt);
    }*/

    function editProduct($p_id,$defaultCategoryId, $categoryId, $price, $active,$availableForOrder,$showPrice, $stockAvailable,$productAttributeIdId, $languageID, $newName, $description, $descriptionShort, $friendlyUrl, $metaTitle, $metaDescription, $metaKeywords,$availableNow,$availableLater,$refernce='', $ImagePath='') {
        global $webService;
        $xml = $webService -> get(array('url' => $this->shopPath. '/api/products?schema=blank'));
        $resources = $xml -> children() -> children();
        $resources -> id=$p_id;
        //  unset($resources -> id);
        unset($resources -> position);
        unset($resources -> id_shop_default);
        unset($resources -> date_add);
        unset($resources -> date_upd);
        unset($resources->associations->combinations);
        unset($resources->associations->product_options_values);
        unset($resources->associations->product_features);
        unset($resources->associations->stock_availables->stock_available->id_product_attribute);
        //unset($resources->associations->categories->category->id);
        //unset($resources-> id_category_default);
        //$resources->position_in_category = '0';
        //unset($resources->position_in_category);
        //$resources -> position = '0';
        //$resources -> id;
        $resources->id_manufacturer = '1';
        $resources->id_supplier = '1';
        $resources->id_category_default = $defaultCategoryId;
        $resources->new = '0'; ; //condition, new is also a php keyword!!
        $resources-> cache_default_attribute;
        $resources-> id_default_image;
        $resources-> id_default_combination = '0';
        $resources-> id_tax_rules_group ='1';
        //$resources-> id_shop_default;
        // $resources-> quantity = $stockAvailable;
        $resources-> reference=$refernce;
        $resources-> supplier_reference;
        $resources-> location;
        $resources-> width;
        $resources-> height;
        $resources-> depth;
        $resources-> weight;
        $resources-> quantity_discount;
        $resources-> ean13;
        $resources-> upc;
        $resources-> cache_is_pack;
        $resources-> cache_has_attachments;
        $resources-> is_virtual;
        $resources-> on_sale;
        $resources-> online_only;
        $resources-> ecotax;
        $resources-> minimal_quantity = 10;
        $resources-> price = $price;
        $resources-> wholesale_price;
        $resources-> unity;
        $resources-> unit_price_ratio;
        $resources-> additional_shipping_cost;
        $resources-> customizable;
        $resources-> text_fields;
        $resources-> uploadable_files;
        $resources-> active = $active;
        $resources-> available_for_order = $availableForOrder;
        $resources-> available_date;
        $resources-> condition;
        $resources-> show_price = $showPrice;
        $resources-> indexed = '1';
        $resources-> visibility = 'both';
        $resources-> advanced_stock_management='0';
        $resources-> date_add;
        $resources-> date_upd;
        $resources->associations->categories->addChild('category')->addChild('id', $categoryId);
        $node = dom_import_simplexml($resources -> name -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($newName));
        $resources -> name -> language[0][0] = $newName;
        $resources -> name -> language[0][0]['id'] = $languageID;
        $resources -> name -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        $node = dom_import_simplexml($resources -> description -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($description));
        $resources -> description -> language[0][0] = $description;
        $resources -> description -> language[0][0]['id'] = $languageID;
        $resources -> description -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        $node = dom_import_simplexml($resources -> description_short -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($descriptionShort));
        $resources -> description_short -> language[0][0] = $descriptionShort;
        $resources -> description_short -> language[0][0]['id'] = $languageID;
        $resources -> description_short -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        $node = dom_import_simplexml($resources -> link_rewrite -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($friendlyUrl));
        $resources -> link_rewrite -> language[0][0] = $friendlyUrl;
        $resources -> link_rewrite -> language[0][0]['id'] = $languageID;
        $resources -> link_rewrite -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        $node = dom_import_simplexml($resources -> meta_title -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($metaTitle));
        $resources -> meta_title -> language[0][0] = $metaTitle;
        $resources -> meta_title -> language[0][0]['id'] = $languageID;
        $resources -> meta_title -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        $node = dom_import_simplexml($resources -> meta_description -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($metaDescription));
        $resources -> meta_description -> language[0][0] = $metaDescription;
        $resources -> meta_description -> language[0][0]['id'] = $languageID;
        $resources -> meta_description -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        $node = dom_import_simplexml($resources -> meta_keywords -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($metaKeywords));
        $resources -> meta_keywords -> language[0][0] = $metaKeywords;
        $resources -> meta_keywords -> language[0][0]['id'] = $languageID;
        $resources -> meta_keywords -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        $node = dom_import_simplexml($resources -> available_now -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($availableNow));
        $resources -> available_now -> language[0][0] = $availableNow;
        $resources -> available_now -> language[0][0]['id'] = $languageID;
        $resources -> available_now -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        $node = dom_import_simplexml($resources -> available_later -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($availableLater));
        $resources -> available_later -> language[0][0] = $availableLater;
        $resources -> available_later -> language[0][0]['id'] = $languageID;
        $resources -> available_later -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        try {
            // $opt = array('resource' => 'products','id' => $p_id);
            // $opt['id']=$p_id;
            //$opt['postXml'] = $xml -> asXML();
            //$opt['id']=$p_id;
            $product = $webService->get(array('resource' => 'products', 'id' => $p_id));
            $xml = $webService->edit(array('resource' => 'products', 'id' => $p_id, 'putXml' =>$xml -> asXML()));
            //$xml = $webService -> edit($opt);
            //## Add image
            $this->add_image_to_product($xml->product->id, $refernce, $ImagePath);
        } catch (PrestaShopWebserviceException $ex) {
            echo '<b>Error : '.$ex->getMessage().'</b>';
            $trace = $ex->getTrace();
            // echo "<pre>";
            print_r($trace);
            //echo "</pre>";
        }
    }

    function insertProduct($defaultCategoryId, $categoryId, $price, $active,$availableForOrder,$showPrice, $stockAvailable,$productAttributeIdId, $languageID, $newName, $description, $descriptionShort, $friendlyUrl, $metaTitle, $metaDescription, $metaKeywords,$availableNow,$availableLater,$refernce='', $discount, $ImagePath='') {
        global $webService;
        $xml = $webService -> get(array('url' => $this->shopPath. '/api/products?schema=blank'));
        $resources = $xml -> children() -> children();
        unset($resources -> id);
        unset($resources -> position);
        unset($resources -> id_shop_default);
        unset($resources -> date_add);
        unset($resources -> date_upd);
        unset($resources->associations->combinations);
        unset($resources->associations->product_options_values);
        unset($resources->associations->product_features);
        unset($resources->associations->stock_availables->stock_available->id_product_attribute);
        //unset($resources->associations->categories->category->id);
        //unset($resources-> id_category_default);
        //$resources->position_in_category = '0';
        //unset($resources->position_in_category);
        //$resources -> position = '0';
        //$resources -> id;
        $resources->id_manufacturer = '1';
        $resources->id_supplier = '1';
        $resources->id_category_default = $defaultCategoryId;
        $resources->new = '0'; ; //condition, new is also a php keyword!!
        $resources-> cache_default_attribute;
        $resources-> id_default_image;
        $resources-> id_default_combination = '0';
        $resources-> id_tax_rules_group ='1';
        //$resources-> id_shop_default;
        // $resources-> quantity = $stockAvailable;
        $resources-> reference=$refernce;
        $resources-> supplier_reference;
        $resources-> location;
        $resources-> width;
        $resources-> height;
        $resources-> depth;
        $resources-> weight;
        $resources-> quantity_discount = $discount;
        $resources-> ean13;
        $resources-> upc;
        $resources-> cache_is_pack;
        $resources-> cache_has_attachments;
        $resources-> is_virtual;
        $resources-> on_sale;
        $resources-> online_only;
        $resources-> ecotax;
        $resources-> minimal_quantity = 10;
        $resources-> price = $price;
        $resources-> wholesale_price;
        $resources-> unity;
        $resources-> unit_price_ratio;
        $resources-> additional_shipping_cost;
        $resources-> customizable;
        $resources-> text_fields;
        $resources-> uploadable_files;
        $resources-> active = $active;
        $resources-> available_for_order = $availableForOrder;
        $resources-> available_date;
        $resources-> condition;
        $resources-> show_price = $showPrice;
        $resources-> indexed = '1';
        $resources-> visibility = 'both';
        $resources-> advanced_stock_management='0';
        $resources-> date_add;
        $resources-> date_upd;

        $resources->associations->categories->addChild('category')->addChild('id', $categoryId);
        $node = dom_import_simplexml($resources -> name -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($newName));
        $resources -> name -> language[0][0] = $newName;
        $resources -> name -> language[0][0]['id'] = $languageID;
        $resources -> name -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        $node = dom_import_simplexml($resources -> description -> language[0][0]);

        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($description));
        $resources -> description -> language[0][0] = $description;
        $resources -> description -> language[0][0]['id'] = $languageID;
        $resources -> description -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;

        $node = dom_import_simplexml($resources -> description_short -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($descriptionShort));
        $resources -> description_short -> language[0][0] = $descriptionShort;
        $resources -> description_short -> language[0][0]['id'] = $languageID;
        $resources -> description_short -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;

        $node = dom_import_simplexml($resources -> link_rewrite -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($friendlyUrl));
        $resources -> link_rewrite -> language[0][0] = $friendlyUrl;
        $resources -> link_rewrite -> language[0][0]['id'] = $languageID;
        $resources -> link_rewrite -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;

        $node = dom_import_simplexml($resources -> meta_title -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($metaTitle));
        $resources -> meta_title -> language[0][0] = $metaTitle;
        $resources -> meta_title -> language[0][0]['id'] = $languageID;
        $resources -> meta_title -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;

        $node = dom_import_simplexml($resources -> meta_description -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($metaDescription));
        $resources -> meta_description -> language[0][0] = $metaDescription;
        $resources -> meta_description -> language[0][0]['id'] = $languageID;
        $resources -> meta_description -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;

        $node = dom_import_simplexml($resources -> meta_keywords -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($metaKeywords));
        $resources -> meta_keywords -> language[0][0] = $metaKeywords;
        $resources -> meta_keywords -> language[0][0]['id'] = $languageID;
        $resources -> meta_keywords -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;

        $node = dom_import_simplexml($resources -> available_now -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($availableNow));
        $resources -> available_now -> language[0][0] = $availableNow;
        $resources -> available_now -> language[0][0]['id'] = $languageID;
        $resources -> available_now -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;

        $node = dom_import_simplexml($resources -> available_later -> language[0][0]);
        $no = $node -> ownerDocument;
        $node -> appendChild($no -> createCDATASection($availableLater));
        $resources -> available_later -> language[0][0] = $availableLater;
        $resources -> available_later -> language[0][0]['id'] = $languageID;
        $resources -> available_later -> language[0][0]['xlink:href'] = $this->shopPath . '/api/languages/' . $languageID;
        try {
            $opt = array('resource' => 'products');
            $opt['postXml'] = $xml -> asXML();
            $xml = $webService -> add($opt);
            //## Add image
            if (!empty($ImagePath)) {
                $this->add_image_to_product($xml->product->id, $refernce, $ImagePath);
            }
        } catch (PrestaShopWebserviceException $ex) {
            echo '<b>Error : '.$ex->getMessage().'</b>';
            $trace = $ex->getTrace();
            // echo "<pre>";
            print_r($trace);
            //echo "</pre>";
        }
    }

    function add_image_to_product($ProductId, $ImageName='', $ImagePath,$Width=640, $Height=640, $ImageQuality=100){
        //Make url
        $url = $this->shopPath."api/images/products/$ProductId/";
        $ImageTmpPath="";
        /*
        $resizeObj = new resize($ImagePath);
        //Resize iamge
        $resizeObj -> resizeImage($Width, $Height);
        //Save resized temp image
        $resizeObj -> saveImage("$ImageTmpPath/$ImageName", $ImageQuality);
        */
        //Uplodad image to a product
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, true);
        //curl_setopt($ch, CURLOPT_PUT, true); // Un-commet to edit an image
        curl_setopt($ch, CURLOPT_USERPWD,$this->authKey.':');
        curl_setopt($ch, CURLOPT_POSTFIELDS, array('image' => $ImageTmpPath.$ImagePath));
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $result = curl_exec($ch);
        if(curl_errno($ch))
        {
            echo 'error:' . curl_error($ch);
        }
        curl_close($ch);
        //Delete temp image
        //unlink("$ImageTmpPath/$ImageName");
    }
    function addCategory($parent_id,$catname,$is_root=0){
        $catname= trim($catname);
        global $webService;
        $xml = $webService -> get(array('url' => $this->shopPath . '/api/categories?schema=blank'));
        $resources = $xml -> children() -> children();
        unset($resources ->id);
        unset($resources ->position);
        unset($resources ->date_add);
        unset($resources ->date_upd);

        unset($resources ->level_depth);
        unset($resources ->nb_products_recursive);
        if(empty($parent_id)){
            unset($resources ->id_parent );
        }else {
            $resources ->id_parent = $parent_id;
        }
        $resources ->name ->language[0][0] = $catname;
        $resources ->link_rewrite->language[0][0] = Slug(strtolower(str_replace(" ","-",$catname)));
        $resources ->active = 1;
        $resources ->id_shop_default = 1;
        $resources ->is_root_category =$is_root;

        try {
            $opt = array('resource' => 'categories');
            $opt['postXml'] = $xml -> asXML();
            $xml = $webService -> add($opt);
            return $xml->category->id;
        } catch (PrestaShopWebserviceException $ex) {
            echo '<b>Error : '.$ex->getMessage().'</b>';
            $trace = $ex->getTrace();
            // echo "<pre>";
            print_r($trace);
            //echo "</pre>";
        }
    }

    function editCategory($c_id,$catname,$parent_id='',$is_root=0){
        global $webService;
        // $xml = $webService -> get(array('url' => $this->shopPath . '/api/categories?schema=blank'));
        $opt = array('resource' => 'categories');
        $opt['id'] = $c_id;
        $xml = $webService->get($opt);
        $resources = $xml -> children() -> children();
        $resources ->id=$c_id;
        unset($resources ->position);
        unset($resources ->date_add);
        unset($resources ->date_upd);
        //unset($resources ->id_parent); //if unset category will be root. If set it must have id existing parent category!
        unset($resources ->level_depth);
        unset($resources ->nb_products_recursive);
        if($parent_id!=''){
            $resources ->id_parent = $parent_id;
        }
        $resources ->name ->language[0][0] = $catname;
        $resources ->link_rewrite->language[0][0] = strtolower(str_replace(" ","-",$catname));
        $resources ->active = 1;
        $resources ->id_shop_default = 1;
        $resources ->is_root_category =$is_root;
        try {
            $opt = array('resource' => 'categories');
            $opt['putXml'] = $xml->asXML();
            $opt['id'] = $c_id;
            $xml = $webService->edit($opt);
            return $xml->category->id;
        } catch (PrestaShopWebserviceException $ex) {
            echo '<b>Error : '.$ex->getMessage().'</b>';
            $trace = $ex->getTrace();
            // echo "<pre>";
            print_r($trace);
            //echo "</pre>";
        }
    }

    function insertCategory(){
        $webService = new PrestaShopWebservice($this->shopPath, PS_WS_AUTH_KEY, DEBUG);
        $xml = $webService -> get(array('url' => $this->shopPath . '/api/categories?schema=synopsis'));
        $resources = $xml -> children() -> children();
        unset($resources ->id);
        unset($resources ->position);
        unset($resources ->date_add);
        unset($resources ->date_upd);
        //unset($resources ->id_parent); //if unset category will be root. If set it must have id existing parent category!
        unset($resources ->level_depth);
        unset($resources ->nb_products_recursive);
        $resources ->id_parent = '6';
        $resources ->name ->language[0][0] = 'test';
        $resources ->link_rewrite->language[0][0] = 'test';
        $resources ->active = 1;
        $resources ->id_shop_default = 1;
        $resources ->is_root_category = 0;
        $opt = array('resource' => 'categories');
        $opt['postXml'] = $xml -> asXML();
        $xml = $webService -> add($opt);
    }

    function getResources($parentResourceName='',$childResourceName='', $getChildrenDetails = true,$returnAsArray=false){
        global $webService;
        $requestsArray = array();
        $requestsArray['resource'] = $parentResourceName;
        // call to retrieve all clients
        $xml = $webService->get($requestsArray);
        $resources = $xml->$parentResourceName->children();
        // get additional detals for children
        if ($getChildrenDetails) {
            $resourceList = array();
            foreach ($resources AS $resource) {
                $requestsArray['id'] = (string) $resource->attributes()->id[0];
                if ($requestsArray['id']) {
                    $xml2 = $webService->get($requestsArray);
                    $details = $xml2->$childResourceName;
                    if ($returnAsArray) {
                        $resourceList[] = $this->xml2array($details );
                    }else {
                        $resourceList[] = $details ;
                    }
                }
            }
            $data = $resourceList;
        }else {
            // return as is
            $data =  $resources;
        }
        if ($returnAsArray) {
            return $this->xml2array($data);
        }else {
            return $data;
        }
    }

    function setProductQuantity($productId, $quantity, $stockId, $attributeId){
        global $webService;
        //$xml = $this->getResources('stock_availables','',false,false);
        $xml = $webService -> get(array('url' => $this->shopPath. '/api/stock_availables?schema=blank'));
        $resources = $xml -> children() -> children();
        $resources->id = $stockId;
        $resources->id_product  = $productId;
        $resources->quantity = $quantity;
        $resources->id_shop = 1;
        $resources->out_of_stock=1;
        $resources->depends_on_stock = 0;
        $resources->id_product_attribute=$attributeId;
        try {
            $opt = array('resource' => 'stock_availables');
            $opt['putXml'] = $xml->asXML();
            $opt['id'] = $stockId ;
            $xml = $webService->edit($opt);
        }catch (PrestaShopWebserviceException $ex) {
            echo "<b>Error : </b>".$ex->getMessage().'<br>';
        }
    }
    function getProductStockIdAndSet($productId,$quantity){
        global $webService;
        $opt['resource'] = 'products';
        $opt['id'] = $productId;
        $xml = $webService->get($opt);
        foreach ($xml->product->associations->stock_availables->stock_available as $item) {
            //echo "ID: ".$item->id."<br>";
            //echo "Id Attribute: ".$item->id_product_attribute."<br>";
            $this->setProductQuantity($productId, $quantity, $item->id, $item->id_product_attribute);
        }
    }


    function xml2array($xml){
        $arr = array();
        foreach ($xml as $element)
        {
            $tag = $element->getName();
            $e = get_object_vars($element);
            if (!empty($e))
            {
                $arr[$tag] = $element instanceof SimpleXMLElement ? $this->xml2array($element) : $e;
            }
            else
            {
                $arr[$tag] = trim($element);
            }
        }
        return $arr;
    }
}