<?php
    require_once('common/header.php');
    $log = new Log();
    $stats = new Statistics(false);
    $days = 365;
?>
<h1 class="title">Statistics</h1>
<div class="form round drop_shadow">


    <table cellpadding="0" cellspacing="0" border="0" class="display" id="example" style="width:98%">
        <thead>

            <tr >
                <th><h2>Date</h2></th>
                <th><h2>Unique Visitors</h2></th>
                <th><h2>Pageviews</h2></th>
            </tr>
        </thead>
        <tbody class="content">
         <?php for($i=0;$i<=$days;$i++) :
                    $date = date('Y-m-d', strtotime("-$i day"));
                    $uniqueVisitors = $stats->uniqueVisitors($date);
                    $pageViews = $stats->pageViews($date);
                    $displayDate = date("d F, Y", strtotime($date));
                ?>
                <tr height="25">
                    <td><?php echo $displayDate; ?></td>
                    <td><?php echo $uniqueVisitors; ?> unique visitor<?php echo $uniqueVisitors == 1 ? '' : 's'; ?></td>
                    <td><?php echo $pageViews; ?> pageview<?php echo $pageViews == 1 ? '' : 's'; ?></td>
                </tr>
                <?php endfor; ?>
        </tbody>
    </table>
    <div class="clear"></div>
</div>

<script>
    $(document).ready(function(){
            $("#example").dataTable({
        "aoColumns": [
            { "asSorting": [ "desc", "asc" ] }, //first sort desc, then asc
        ]
    } );
    });
</script>
<?php require_once('common/footer.php'); ?>