<?php
    header("Content-Type: text/html; charset=utf-8");
    require_once('../../server/api-adodb/config.php');
    ob_start();
    require_once(LIB_PATH.DS.'loggedin.php');

    require_once(LIB_PATH.DS.'site.class.php');

    $table = new Table();
    $allTables = $table->listAllTables();
    $currentPage = basename($_SERVER['REQUEST_URI']);
    if(!empty($_GET['table'])){
        $user->allowed($_GET['table']);
    }
    //Checks if the user has changed the default username and password or not
    if($user->passwordIsDefault() && !currentPageIs('administrators.php') && !currentPageIs('administrators_edit.php')) {
        $session->message("Please change the default username and password!");
        redirect_to("administrators.php");
    }

    $stats = new Statistics();
    $site = new Site();


?>
<!DOCTYPE>
<html>
<head>
    <title><?php echo $site->project_name; ?> Administration</title>
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo "../".$site->favicon; ?>" />

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <link href="<?php echo ADMIN_PATH_HTML;?>/css/reset.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo ADMIN_PATH_HTML;?>/css/960.css" rel="stylesheet" type="text/css"/>
    <link href="<?php echo ADMIN_PATH_HTML;?>/css/redmond/j.css" media="all" rel="stylesheet" type="text/css" />

    <link href="<?php echo ADMIN_PATH_HTML;?>/css/adminStyles.css" media="all" rel="stylesheet" type="text/css" />



    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/css/metro/js/jquery-1.9.0.min.js"></script>
    <?php require("common/metro_includes.php");?>


    <link href="<?php echo ADMIN_PATH_HTML;?>/js/datatables/css/dt_table.css" media="all" rel="stylesheet" type="text/css" />
    <link href="<?php echo ADMIN_PATH_HTML;?>/js/datatables/css/dt_page.css" media="all" rel="stylesheet" type="text/css" />
    <link href="<?php echo ADMIN_PATH_HTML;?>/js/datatables/ColVis.css" media="all" rel="stylesheet" type="text/css" />

        <link href="<?php echo ADMIN_PATH_HTML;?>/css/branding_moka.css" media="all" rel="stylesheet" type="text/css" />


    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/js/livequery.js"></script>
    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/js/scripts.js"></script>

    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/js/jqueryui.js"></script>
    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/js/jquery.ui.dialog.js"></script>
    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/js/jquery.jeditable.js"></script>


    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/js/validator/jquery.bvalidator-yc.js"></script>
    <link href="<?php echo ADMIN_PATH_HTML;?>/js/validator/bvalidator.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/js/modernizr-1.6.min.js"></script>

    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML;?>/js/datatables/ColVis.min.js"></script>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <script type="text/javascript">
        var options = {
            ajaxAnswerValid: 'ok'
        };
        $(document).ready(function () {
            $('form').bValidator(options);
        });

        function redirect(tableName){
            <?php if(REWRITE_ENABLED) : ?>
                window.location = "../list/"+tableName+".html";
                <?php else : ?>
                window.location = "../list.php?table="+tableName;
                <?php endif; ?>
        }
    </script>


<style>
#menu li > a:first-child{
    padding-top:3px;
    padding-bottom: 3px;
}
</style>
</head>
<body class='metrouicss'>
<div id="saveResult" class="drop_shadow round"></div>

<!-- top menu -->
<div id="toprightDropMenu">
    <ul id="coolMenu">
        <li><?php echo CMSGEN_TITLE; ?> v<?php echo CMSGEN_VERSION; ?></li>
        <?php if(  LIVE_EDIT  ) : ?>
        <li><a href="<?php echo PUBLIC_HTML_SITE.DS; ?>index.php">Switch to live editing</a></li>
         <li style='padding-left:0;padding-right: 0;'>|</li>
        <?php endif; ?>

        <li>
            <a href="#">Options</a>
            <ul class="noJS drop_shadow" >
                <?php
                    if($user->isAllowed('administrators_edit')) :
                    ?>
                    <li><a href="<?php echo pageLink('administrators.php'); ?>">Users</a></li>
                    <?php endif; ?>
                <?php
                    if($user->isAllowed('cmsgen_cpanel_editor_links')) :
                    ?>
                    <li><a href="<?php echo pageLink('generate.php?table=site_options&id=1'); ?>">Configure CMS</a></li>
                    <?php endif; ?>

                <?php if(HOSTED_WITH_US && $user->user_level >= 9) : ?>
                    <li><a href="<?php echo pageLink('generate.php?table=admin_advanced_settings&id=1'); ?>">Advanced Settings</a></li>
                    <li><a href="<?php echo pageLink('list.php?table=cmsgen_cpanel_links'); ?>">Cpanel Links</a></li>
                    <?php endif; ?>

                <?php
                    if($user->isAllowed('cmsgen_cpanel_editor_links')) :
                        $array = $table->listAllCpanelLinks();
                        if($array !== false) :
                            foreach($array as $link) :
                            ?>
                            <li><a href="<?php echo $link['link']; ?>"><?php echo $link['name']; ?></a></li>
                            <?php
                                endforeach;
                            endif; // $array != false
                        endif; // IsAllowed() if
                ?>

            </ul>
        </li>
         <li style='padding-left:0;padding-right: 0;'>|</li>
         <li><a href="<?php echo pageLink('logout.php'); ?>">Logout</a></li>
    </ul>
</div>
<div id="menu_container" class="">
    <div class="logo_bigcontainer">
        <div class="logo_container">
            <div  style=" top:0px; background-color:#fff;  z-index: 9999; width: 241px;" ><img src="<?php echo ADMIN_PATH_HTML;?>/images/logo-menu.png"/></div>
            <div class='user_info'>
                <b>Howdy <?php echo $user->name(); ?></b><br />
                <?php echo date('l jS \of F Y'); ?><br />
                <div class='logout'><a href="<?php echo pageLink('logout.php'); ?>">Logout</a></div>
            </div>
        </div>
    </div>

    <div class="openLink menuOpen">&laquo;</div>

    <ul id="menu">
        <li><a href="<?php echo pageLink('dashboard.php'); ?>" class="<?php echo (strpos($currentPage, 'dashboard') !== false ? 'selected' : '' )?>">Dashboard</a></li>
        <?php
            $checkExists = new Table();
            if($checkExists->tableExists('cmsgen_galleries')) :
            ?>
            <li><a href="<?php echo pageLink('zip_upload.php'); ?>" class="<?php echo (strpos($currentPage, 'zip_upload') !== false ? 'selected' : '' )?>">Zip Upload</a></li>
            <?php endif; ?>

        <?php
            if($checkExists->tableExists('cmsgen_mailing_list')) :
            ?>
            <li><a href="<?php echo pageLink('send_mailing_list.php'); ?>" class="<?php echo (strpos($currentPage, 'send_mailing_list') !== false ? 'selected' : '' )?>">Send Mailing List</a></li>
            <?php endif; ?>

            <li><a href="reports.php"  class="<?php echo (strpos($currentPage, 'report') !== false ? 'selected' : '' )?>">Reports</a></li>
        <?php
            #adding menu buttons manually.
            /*
            <li><a href="#"  class="<?php echo (strpos($currentPage, 'background_images') !== false ? 'selected' : '' )?>">BG Images</a></li>
            */

            // reorder tables as in language.php
            $allTables = reorderTable($allTables);

            foreach($allTables as $tableName=>$index):
                if(in_array($tableName,$oneRowTables)){
                    continue;
                }

                if(strpos($tableName,"habtm_") !== false){
                    continue;
                }
            ?>
            <li><a href="<?php echo pageLink('list.php?table='.$tableName); ?>" <?php echo isMenuItemSelected($tableName) ? 'class="selected"' : '' ; ?>><?php echo printTableName($tableName); ?></a> <a href='<?php echo pageLink('generate.php?table='.$tableName);?>'>[ + ]</a></li>
            <?php endforeach; ?>


    </ul>
</div>
<div id="cmsBody">
<?php if(!empty($message)) : ?>
    <div class="message round drop_shadow <?php echo isSuccess($session->message()) ? 'success' : 'fail'; ?>">
        <?php echo str_replace('@success@','',$session->message()); ?>
    </div>
    <?php endif; ?>
