<?php
    if(!isset($id)){
        $id = NULL;
    }

    if(isset($_GET['version']) && !empty($_GET['version']) ){
        $versionId =  (int)$_GET['version'];  
    }else{
        $versionId = null;
    }
?>
<iframe id="upload_target" name="upload_target" src="blank_iframe.html" style="width:0;height:0;border:0px solid #fff;"></iframe>
<form action="<?php echo pageLink('actions/upload.php'); ?>" method="post" id="generateForm" class="form" enctype="multipart/form-data" target="upload_target"  onsubmit="startUpload();">
    <h1 class="title"><?php echo printTableName($tableName) ; ?>
        <?php if($table->isCrudEnabled()) : ?><a href="<?php echo pageLink('generate.php?table='.$tableName); ?>" >[ + ]</a><?php endif; ?>
    </h1>
    <hr />
    <h3><?php echo empty($id) ? 'Create a new entry' : 'Update Entry'; ?> <span id="result" style='color:#6e6;font-weight: bold;'></span></h3><br /><br />

    <?php
        //Loop through the current table's fields and output the corresponding form
        foreach($table->returnFieldsNamesTypes() as $fieldName => $fieldTypeLength){
            if($fieldName == 'id' || $fieldName == 'pos'){
                continue;
            }

            echo'<div class="field"><label class="input-control text"><div class="label '. ($table->isRequired($fieldName) ? 'required' : '' ) .'">';

            $tooltip = $table->getTooltip($fieldName);

            echo printTableName($fieldName);
            echo'</div>';
            echo $table->getFormElement($fieldName,$id,$versionId); //Displays the corresponding form element to the following field
            if(!empty($tooltip))
                echo '<span title="'.$tooltip.'" class="tooltipMessage"></span>';

            echo '</label></div>';
            echo '<br />';

        }
    ?>
    <br style="clear: both;" />
    <div style="float: left; margin-top: 20px;">
        <?php if ($table->isPhotoGallery() && empty($_GET['id'])) : ?>
            <input class="submit round drop_shadow triggerFineUploader" type="button" value="Save" style="float:left" />
            <?php else : ?>
            <input class="submit round drop_shadow" id="save" type="submit" value="Save" style="float:left" />
            <?php endif; ?>

            <input type="hidden" name="token" value="<?php echo CSRF::generateToken(); ?>" />
        <input class="submit round drop_shadow"  type="reset" value="Reset" style="float:left;margin-left:4px;">
    </div>
    <input type="hidden" name="data[<?php echo $tableName; ?>][id]" value="<?php echo $id; ?>" />
    <input type="hidden" name="table" value="<?php echo $tableName; ?>" />
    <div class="clear"></div><br />
    <?php if(!in_array($tableName,$oneRowTables)) :  ?>
        <a href="<?php echo pageLink('list.php?table='.$tableName); ?>" style="clear:both;" class="listAllRecordsLink">List all records</a>
        <?php endif; ?>


    | <a href="<?php             echo $table->returnFormatedLink($id);         ?>">View on website</a>
</form>


    <?php if(!empty($id) && ($table->countContentHistoryById($id) > 0 )) : 
            $versions = $table->getContentHistoryByRowId($id);
        ?>
        <br />
        <!-- Content version history drop down-->
        <div class="content-version">
            <?php echo $table->countContentHistoryById($id) . ' older versions you can revert back to. '; ?>

            <div class="field input-control text">
                <select name="versionId" id="changeDateSelect" data-current-table="<?php echo $tableName; ?>" data-current-id="<?php echo $id; ?>" onchange="document.location = this.value">
                    <option value="<?php echo pageLink("generate.php?table={$tableName}&id={$id}"); ?>">No version selected</option>
                    <?php $i=0; foreach($versions as $version) : $i++;
                            if($i == 1){
                                continue; 
                            }
                        ?>
                        <option value="<?php echo pageLink("generate.php?version={$version['id']}&table={$tableName}&id={$id}"); ?>" <?php echo $versionId == $version['id'] ? ' selected="selected" ' : ''; ?>><?php echo date("d F, Y @ h:i:s",strtotime($version['created'])); ?> -- by <?php echo User::getUsername($version['edited_by']); ?></option>
                        <?php endforeach; ?>
                </select>
            </div>
        </div>
        <?php endif; ?>