<?php
require_once("requires.php");
if (empty($_SESSION['user'])) {
    header("Location:index.php");
}

$user = reset( $_SESSION['user'] );

$transactionsObj = new Table("transaction");

$q="
SELECT *
FROM transaction
LEFT JOIN pos ON ( transaction.pos_id = pos.id )
LEFT JOIN location ON ( location.id = pos.location_id )
LEFT JOIN operations ON ( operations.id = location.link_operation )
LEFT JOIN country ON ( country.id = operations.link_country )
WHERE transaction.card_id =  '{$user['Cardnumber']}'
ORDER BY DATE DESC
LIMIT 10
";



$transactions = $transactionsObj->executeSql ($q);

require_once('header.php');
 ?>
    <div id="page">
        <div class="container">
            <div class="wrapper">
				<div class="price-content">
					<div class="price-header">
						<img src="img/price-bg.jpg" alt="">
					</div>
					<div class="user-info pure-g-r">
						<div class="pure-u-1-5 user">
							<img src="img/icon-user.png" alt="">
							<span id="user"><?php echo $user['Firstname'].' '.$user['Lastname']; ?></span>
						</div>
						<div class="pure-u-1-5 ammount">
							<img src="img/icon-ammount.png" alt="">
							<span id="ammount"><?php echo round($user['Balance'],2); ?>$</span>
						</div>
						<div class="pure-u-1-5 points">
							<img src="img/icon-point.png" alt="">
							<span id="points"><?php echo round( $user['Loyalty_balance'],2); ?></span>
						</div>
						<div class="pure-u-2-5 recharge">
							<a href="recharge.php">
								<img src="img/icon-recharge.png" alt="">
							</a>
						</div>
					</div>
					<table>
						<thead>
							<tr>
								<th>Date</th>
								<th>Location</th>
								<th>Amount</th>
								<th>Points</th>
								<th>Action</th>
							</tr>
						</thead>
						<tbody>
                        <?php
                            foreach($transactions AS $k=>$transaction) {
                        ?>
							<tr>
								<td><?php echo date("Y.M.d H:i:s",$transaction['Date'])     ;?></td>
								<td><?php echo $transaction['Location']; ?></td>
								<td><?php echo round( $transaction['Amount'], 2); ?></td>
								<td><?php echo round( $transaction['Loyalty_points'], 2); ?></td>
								<td><?php echo str_replace("Reduce","Buy",ucwords(str_replace("_"," ",$transaction['Action']))); ?></td>
							</tr>
                        <?php } ?>
<!--
                            <tr>
								<td>14-8-2014</td>
								<td>Beirut Souks</td>
								<td>12$</td>
								<td>32</td>
								<td>Milkshake, strawberry tart</td>
							</tr>
							<tr>
								<td>18-6-2014</td>
								<td>City Mall</td>
								<td>10$</td>
								<td>28</td>
								<td>Nespresso, chocolate muffin</td>
							</tr>
							<tr>
								<td>14-8-2014</td>
								<td>Beirut Souks</td>
								<td>12$</td>
								<td>32</td>
								<td>Milkshake, strawberry tart</td>
							</tr>
							<tr>
								<td>18-6-2014</td>
								<td>City Mall</td>
								<td>10$</td>
								<td>28</td>
								<td>Nespresso, chocolate muffin</td>
							</tr>
							<tr>
								<td>14-8-2014</td>
								<td>Beirut Souks</td>
								<td>12$</td>
								<td>32</td>
								<td>Milkshake, strawberry tart</td>
							</tr>
							<tr>
								<td>18-6-2014</td>
								<td>City Mall</td>
								<td>10$</td>
								<td>28</td>
								<td>Nespresso, chocolate muffin</td>
							</tr>
							<tr>
								<td>14-8-2014</td>
								<td>Beirut Souks</td>
								<td>12$</td>
								<td>32</td>
								<td>Milkshake, strawberry tart</td>
							</tr>
                            -->
						</tbody>
					</table>
				</div>
            </div>
        </div>
    </div>
<?php require_once('footer.php'); ?>