<?php
$pageData = $MAIN->getPageData();
$services = $MAIN->getServices();

$activeSectionSlug = '';
$slugs = array();

if ( isset ($services) && !empty ($services) ){
	foreach ($services as $service){
		$slugs[] = makeSlug($service['title'].'-'.$service['title_secondary']);
	}
	$firstServiceSlug = $services[0]['title'].'-'.$services[0]['title_secondary'];
	$activeSectionSlug = $MAIN->theGet(2) ? $MAIN->theGet(2) : makeSlug($firstServiceSlug);
}

// example URL: what-we-do/test
// if "test" is not a section in services
// we redirect to main "what-we-do" URL
if ( $MAIN->theGet(2) && !in_array($MAIN->theGet(2), $slugs) ){
	header("Location: ".HTML_SITE.DS.'what-we-do');
	exit;
}

$MAIN->header();

$activeSection = array("$activeSectionSlug"=>'active');
?>
<div class="whiteBg"></div>

<div class="row" id='whatwedo'>
    <section>
        <div class="title">
            <h1>WHAT</h1>
            <h1 class="green">WE DO</h1>
        </div>
        <div class="large-9 column">
					<?php echoV($pageData, 'page_what_we_do_head,description');?>
        </div>
        <div class="large-3 column show-for-medium-up">
            &nbsp;
        </div>
    </section>
    <div class="clearfix"></div>
    
</div>    
    
   
<div class="row">    
    <dl class="tabs" data-tab>
			<?php
			$c = 0;
			foreach ($services as $service){
				$c++;
				$slug = makeSlug($service['title'].'-'.$service['title_secondary']);
				$serviceColor = $service['main_color'];
				?>
				<dd class="<?php echo $activeSection[$slug];?>">
					<a href="#panel-<?php echo $slug;?>" class="c-<?php echo $slug;?>">
						<div class="background background-<?php echo $slug;?>"></div>
						<h4><?php echo $service['title'];?></h4>
						<h4><b><?php echo $service['title_secondary'];?></b></h4>
					</a>
				</dd>
				<style>
				.background-<?php echo $slug;?>{
					background: url("<?php echo $service['icon_image_inactive'];?>") no-repeat;
				}
				#what-we-do dd.active .background-<?php echo $slug;?>{
					background: url("<?php echo $service['icon_image_alternate'];?>") no-repeat;
				}
				#what-we-do .tabs dd.active a.c-<?php echo $slug;?>, #what-we-do a:hover .c-<?php echo $slug;?>{
					background: #<?php echo $serviceColor;?>
				}
				</style>
				<?php
			}
			?>
    </dl>
   </div> 
 <div id="allTabs">   
<div class="row">     
    <div class="tabs-content">
			<?php
			$c = 0;
			foreach ($services as $key => $service){
				$c++;
				$slug = makeSlug($service['title'].'-'.$service['title_secondary']);
				$serviceColor = $service['main_color'];
				?>
				
				<div class="content <?php echo $activeSection[$slug];?> t<?php echo key?>" id="panel-<?php echo $slug;?>" data='<?php echo $serviceColor;?>'>
					<div class="large-4 column" >
						<div class="inner-title c-<?php echo $slug;?>" >
							<h1 style="color: #fff" ><?php echo $service['title'];?></h1>
							<h1 class="c-<?php echo $slug;?>"><b><?php echo $service['title_secondary'];?></b></h1>
						</div>
						<div class="data" style="color: #fff"><?php echo $service['description'];?></div>
					</div>
					<div class="large-8 column"><img style="z-index: 0" src='<?php echo thumbnailLink($service['image'],'','');?>' alt='<?php echo $service['title'].' '.$service['title_secondary'];?>'></div>
					<style>
						#what-we-do .content h1.c-<?php echo $slug;?>, #what-we-do .content .c-<?php echo $slug;?>, #what-we-do #panel-<?php echo $slug;?>.content .data strong{
							color: #fff<?php //echo $serviceColor;?>;
							border-color: #fff<?php ///echo $serviceColor;?>
						}
						
						.tabs-<?php echo $key;?>{background-color:#<?php echo $serviceColor;?>  }
					</style>
        </div>
        
        
				<?php
			}
			?>
    </div>
</div>
</div> 




<?php
$MAIN->footer();
?>