<?php
$MAIN->header();

$newsOffset = 6;
$news = $MAIN->getNews( array('limit'=>$newsOffset) );
?>
<section class="news main-block">
    <div class="row">
        <div class="title">
            <h1>RECENT</h1>
            <h1 class="blue"><b>NEWS</b></h1>
        </div>
        <div class="large-12">
            <ul id="news-more-wrapper" class="large-block-grid-3 medium-block-grid-2 small-block-grid-1">
							<?php
							$c = 0;
							foreach ($news as $newsEntry){
								$c++;
								$date = strtotime($newsEntry['date'], time());
								$newsEntryDate = date ('d-m-Y', $date);
								?>
								<div id="news-modal-<?php echo $c;?>" class="reveal-modal" data-reveal>
										<div class="large-6 image column"> <img src='<?php echo thumbnailLink($newsEntry['image'], 747, 544);?>' width='100%'></div>
										<div class="large-6 column">
												<div class="data">
												<br>
														<p>
																<b class="blue"><?php echo $newsEntry['title']?></b><br>
																<span class="date blue light italic"><?php echo $newsEntryDate;?></span>
																<br>
																<?php echo $newsEntry['description'];?>
														</p>
												</div>

												<a class="close-reveal-modal">&#215;</a>
										</div>
								</div>
								<li>
										<a href="#" data-reveal-id="news-modal-<?php echo $c;?>">
												<div class="image">
														<div class="layer text-center">
																<img src='assets/img/loop.png' class="removeOnMob">
																<h5>READ</h5>
																<h5>FULL STORY</h5>
														</div>
														<img src='<?php echo thumbnailLink($newsEntry['image'], 374, 241);?>'>
												</div>
												<div class="data">
														<p>
																<b class="blue"><?php echo $newsEntry['title'];?></b><br>
																<span class="date blue light italic"><?php echo $newsEntryDate;?></span>
																<br>
																<?php echo $newsEntry['summary'];?>
														</p>
												</div>
										</a>
								</li>
								<?php
							}?>
            </ul>

            <div class="clearfix"></div>
            <div id="loadMore" class="load-more-news text-center">
                <a data-offset="<?php echo $newsOffset;?>" class="greenButton">- LOAD MORE -</a>
            </div>
        </div>

    </div>
</section>
						
<?php
$MAIN->footer();
?>