<?php
    require_once('common/header.php');


    //Sort the tables from parent to child
    $table = new Table();
    $allEditableTables = $table->listAllEditableTables();
    $i = 0;
    $parentsTableArray = array ();
    while( $parentStart = array_shift($allEditableTables) ){
        $table = new Table($parentStart);
        $parentsTableArray[$i][] = $parentStart;
        while( ($parent = $table->getRootTable($parentStart)) && ($parent != $parentsTableArray[$i][0]) ){
            $parentsTableArray[$i][] = $parent;
            $parentStart = $parent;
        }
        $i++;
    }

    function cmparraysize($a,$b)
    {
        if (sizeof($a)==sizeof($b)) return 0;
        return (sizeof($a)<sizeof($b))?-1:1;
    }

    usort($parentsTableArray,'cmparraysize');
    $parentTables = array();
    foreach($parentsTableArray as $array){


        foreach($array as $t){
            if(!in_array($t,$parentTables)){
                $parentTables [] = $t;   
            }
        }
    }

    /**

    Old Sort

    foreach ($allEditableTables as $tableName){
    $tempTable = new Table($tableName);
    $parentTable = $tempTable->getRootTable($tableName);
    if(empty($parentTable)){
    $parentTable = $tableName;
    }
    $parentTables [] = $parentTable;
    }
    //Keep only unique values
    $parentTables = array_unique($parentTables);

    END OLD SORT
    **/

?>
<div class="sitemap">
    <h1 class="title">Site map</h1>

    <hr />

    <a href="#" class="showIdsBtn">Show IDs [<span class="sign">+</span>]</a>
    <?php

        $options = array (
            'options' => array (
                'limit' => 5
            )
        );

        foreach($parentTables as $tableName){
            if(TableTraversal::beenVisited($tableName)){
                continue;
            }

            echo '<div class="table">';
            echo '<h2 style="cursor:pointer" onclick="window.location.href=\'' . pageLink('list.php?table='.$tableName) . '\'">'.printTableName($tableName).' <span style="font-size:14px">[ <a href="'.pageLink('generate.php?table='.$tableName).'">+</a> ]</span></h2>';
            printSitemapByTableName($tableName,$options);
            echo '</div>';   
        }
    ?>
</div>

<div id="loadMoreModal">
    <form action="<?php echo ''. ADMIN_PATH_HTML.DS.'actions'.DS.'loadMoreSitemap.php' .''; ?>" method="post" class="loadMoreForm">
        <label>Number of records to load. (0 for all)<br /><br />
            <input type="text" name="count" value="0" />
        </label>
        <br /><br />
        <label>Order by<br /><br />
            <select name="order_by" class="orderBySelect">
                <option value="">Please select a column to order the results by</option>
            </select>
        </label><br /><br />
        <input type="hidden" name="tableName" />
        <input type="hidden" name="foreignKey" />
        <input type="hidden" name="foreignKeyId" />

        <input type="submit" value="Load..." class="loadMoreSubmit" />
    </form>
</div>
<?php
    /*
    IMAGE POP
    */
    include(ADMIN_PATH.DS."plugins".DS."imagepop.php");
?>
<style type="text/css">
    .sitemap ul{
        margin-left:20px;
    }
    .sitemap ul.parentMenu {
        margin-bottom:20px;
    }
    .sitemap .table{
        padding:10px; background-color:#FFF;
        margin-bottom:10px;
    }
</style>
<?php require_once('common/footer.php'); ?>