<?php
    require_once('common/header.php');

    if(isset($_POST) && !empty($_POST['ids'])){
        foreach($_POST['ids'] as $id){
            $id = (int)$id;
            if($currUser = User::find_by_id($id)){
                $currUser->delete();
            }
        }
    }

    $allUsers = User::find_all();
    $user->allowed('administrators_edit');
?>
<form action="administrators.php" method="post" enctype="multipart/form-data">
    <h1 class="title">All Admins</h1>
    <div class="form round drop_shadow" id="list">
        <table cellpadding="4" width="100%" style="font-size:12px;">
            <tr>
                <td><h2>ID</h2></td>
                <td><h2>Username</h2></td>
                <td><h2>Password</h2></td>
                <td><h2>Email</h2></td>
                <td><h2>User Level</h2></td>
                <td><h2>Edit</h2></td>
                <td align="center">
                    <input type="checkbox" id="select-all" />
                </td>
            </tr>
            <?php foreach($allUsers as $currentUser) : ?>
                <tr height="30" style="border-bottom:thin solid #eeeee1;line-height:30px;" id="<?php echo $currentUser->id; ?>">

                    <td ><?php echo $currentUser->id; ?></td>
                    <td ><?php echo h($currentUser->username); ?></td>
                    <td ><em>encrypted</em></td>
                    <td ><?php echo $currentUser->email; ?></td>
                    <td ><?php echo $currentUser->user_level; ?></td>

                    <td width="30">
                        <a href="administrators_edit.php?id=<?php echo $currentUser->id; ?>"><img src="<?php echo ADMIN_PATH_HTML;?>/images/file_edit.png" width="20" alt="Edit" /></a>
                    </td>
                    <td  align="center">
                        <input type="checkbox" name="ids[]" value="<?php echo $currentUser->id; ?>" />
                    </td>

                </tr>
                <?php endforeach; ?>
        </table>
        <div class="clear"></div>
        <br />

        <input type="hidden" name="table" value="<?php echo $tableName; ?>" />
        <input class="submit round drop_shadow"  type="button" value="Add" ONCLICK="window.location.href='administrators_edit.php?action=new'"  style="float:left;margin-left:4px;" />

        <input type="submit" name="delete" class="submit round drop_shadow ConfirmDelete" value="Delete" style="float:left;margin-left:4px;" />

        <input class="submit round drop_shadow" type="button" value="Inverse" id="inverse" style="float:left;margin-left:4px;" />

        <div class="clear"></div>
    </div>
   </form>

<?php require_once('common/footer.php'); ?>