<?php
require_once( "common/init.php");
$MAIN->processRoute();

$img = $MAIN->getHomeGallery();

$homepageData = $MAIN->getHomepageData();
$clients = $MAIN->getClients( array('limit'=>12) );
$projects = $MAIN->getProjects( array('limit'=>6) );
$services = $MAIN->getServices ();
$members = $MAIN->getMembers ( array('isKeyMember'=>1) );

$MAIN->header();
?>
	<div id='banners'>
		<!--  <div id="Stage" class="EDGE-26017227"></div>-->
		
		
	
		<ul class="rslides">
<?php foreach($img as $key => $val){ ?>
		  <li><img src="<?php echo thumbnailLink($val['image'], 1920, 1079);?>" alt=""></li>
<?php }?>
		</ul>
		
	</div>
        <section id='projects'>
            <div class="row">
                <div class="title">
                    <h1>INSPIRING</h1>
                    <h1 class="green">PROJECTS</h1>
                </div>
                <div class="large-4">
									<?php echoV($homepageData, 'projects_head,description');?>
                </div>
                <div class="large-12">
                    <div id="container">
						<?php
						foreach ($projects as $project){?>
							<div class="large-4 medium-6 column">
								<img src='<?php echo thumbnailLink($project['image'], 390, 390);?>' class="image">
								<div class="text">
										<div class="large-12 column">
												<div class="inner-title">
													<h4 class='light'><?php echo $project['title'];?></h4>
													<h4 class='bold'><?php echo $project['title_secondary'];?></h4>
													<u><b>Projects:</b></u>
													<p><?php echo $project['projects'];?></p>
													<u><b>Present on:</b></u>
													<p><?php echo $project['present_on'];?></p>
													<a href='portfolio/<?php echo makeSlug($project['id']);?>' style="color: #333">
                                                        <div class="project-wrapper">
                                                            <p>FULL PROJECT</p>
                                                        </div>
                                                    </a>
												</div>
										</div>
								</div>
							</div>
							<?php
						}
						?>
                    </div>
                    <a href='portfolio' class="greenButton right">- FULL PORTFOLIO -</a>
                </div>
            </div>
        </section>
        <section id='clients'>
            <div class="row">
                <div class="title">
                    <h1>LOYAL</h1>
                    <h1 class="green">CLIENTS</h1>
                </div>
                <div class="large-4">
									<?php echoV($homepageData, 'clients_head,description');?>
                </div>
                <div class="large-12">
									<ul class="clients large-block-grid-6 medium-block-grid-5 small-block-grid-2">
										<?php
										foreach ($clients as $client){
											?>
											<li><div class='item'><img src='<?php echo thumbnailLink($client['image'],'','');?>' alt=''></div></li>
											<?php
										}?>
									</ul>
									<a href='clients' class="greenButton right">- LIST OF CLIENTS -</a>
                </div>
            </div>
        </section>
        <section id='services'>
            <div class="row">
                <div class="title">
                    <h1>OUTSTANDING</h1>
                    <h1 class="green">SERVICES</h1>
                </div>
                <div class="large-4 slogan">
									<?php echoV($homepageData, 'services_head,description');?>
                </div>
                <div class="services">
                    <div class="large-12">
                        <ul class="large-block-grid-3">
													<?php
													$c = 0;
													foreach ($services as $service){
														$c++;
														$slug = makeSlug ($service['title'].'-'.$service['title_secondary']);
													?>
                            <li>
                                <div class="item">
                                    <?php
																		if ($service['icon_image']){?>
																			<img src='<?php echo thumbnailLink($service['icon_image'],'','');?>'>
																			<?php
																		}?>
                                    <h4><?php echo $service['title'];?></h4>
                                    <h4 class="c<?php echo $c;?>"><b><?php echo $service['title_secondary'];?></b></h4>
                                    <p><?php echo $service['summary'];?></p>
                                    <a href='what-we-do/<?php echo $slug;?>'><img src='assets/img/full-service-grey.png'></a>
                                </div>
                            </li>
														<?php
													}?>
                        </ul>
                    </div>
                </div>
            </div>
        </section>
        <section id='members'>
            <div class="row">
                <div class="title">
                    <h1>KEY</h1>
                    <h1 class="green">MEMBERS</h1>
                </div>
                <div class="large-4">
									<?php echoV($homepageData, 'members_head,description');?>
                </div>
                <div class="large-12">
                    <ul class="large-block-grid-3">
											<?php
                      $c = 0;

											foreach ($members as $member){
                                $c++;

                                                ?>
                                                    <div id="member-modal-<?php echo $c;?>" class="reveal-modal" data-reveal>
                                        <div class="large-6 image column"> <img src='<?php echo thumbnailLink($member['image'], 382, 382);?>' width='100%'></div>
                                        <div class="large-6 column">
                                                <div class="popup-title">
                                                        <h3 class="bold green"><?php echo $member['firstname'].' '.$member['lastname'];?></h3>
                                                        <h3 class='light'><?php echo $member['job_title'];?></h3>
                                                </div>
                                                <?php echo $member['description'];?>
                                                <a class="close-reveal-modal">&#215;</a>
                                        </div>
                                </div>
                        <li>
                                                <a data-reveal-id="member-modal-<?php echo $c;?>">

                            <img src='<?php echo thumbnailLink($member['image'], 382, 382);?>'>
                            <div class="inner-title">
                                <h3><?php echo $member['firstname'];?></h3>
                                <h3 class="bold green"><?php echo $member['lastname'];?></h3>
                                <p> <b><?php echo $member['job_title'];?></b><br>
                                    <?php echo $member['summary'];?></p>
                            </div>
                        </a>
                        </li>
											<?php
											}?>
                    </ul>
                </div>
            </div>
        </section>
        

				
<?php $MAIN->footer();?>