<?php
function arrayKeysFromID ( $array ){
	if ( is_array($array) && !empty ($array) ){
		foreach ($array as $k=>$v){
			foreach ($v as $kk=>$vv){
				$output[$kk] = $vv;
			}
		}
	}
	return ( isset($output) ) ? $output : array();
}
function shuffle_assoc($list) { 
	if (!is_array($list)) return $list; 

	$keys = array_keys($list); 
	shuffle($keys); 
	$random = array(); 
	foreach ($keys as $key) { 
		$random[$key] = $list[$key]; 
	}
	return $random; 
}
function writeToJSON($json_file, $json_data){
	try{
		$fp = fopen( $json_file, 'w');
		$res = fwrite ($fp, $json_data );
		fclose ($fp);
	}
	catch (Exception $e) {}
}

// convert RSS pubDate to time
function rsstotime($rss_time) {
	$day = substr($rss_time, 5, 2);
	$month = substr($rss_time, 8, 3);
	$month = date('m', strtotime("$month 1 2011"));
	$year = substr($rss_time, 12, 4);
	$hour = substr($rss_time, 17, 2);
	$min = substr($rss_time, 20, 2);
	$second = substr($rss_time, 23, 2);
	$timezone = substr($rss_time, 26);

	$timestamp = mktime($hour, $min, $second, $month, $day, $year);

	date_default_timezone_set('UTC');

	if(is_numeric($timezone)) {
			$hours_mod = $mins_mod = 0;
			$modifier = substr($timezone, 0, 1);
			$hours_mod = (int) substr($timezone, 1, 2);
			$mins_mod = (int) substr($timezone, 3, 2);
			$hour_label = $hours_mod>1 ? 'hours' : 'hour';
			$strtotimearg = $modifier.$hours_mod.' '.$hour_label;
			if($mins_mod) {
					$mins_label = $mins_mod>1 ? 'minutes' : 'minute';
					$strtotimearg .= ' '.$mins_mod.' '.$mins_label;
			}
			$timestamp = strtotime($strtotimearg, $timestamp);
	}

	return $timestamp;
}
function echo_special_head ( $input, $array_keys='' ){
	$head = echoV ($input, $array_keys, 'return');
	echo strip_tags($head,'<a>');
}

function get_query_i ($sql, $limit=0){
	global $_wpdb;
	
	if($result = $_wpdb->query($sql)){
		while($entry = $result->fetch_assoc()){
			$data[] = $entry;
		}
	}
	if ($limit == 1 && !isset($data[0]) ){
		$data[0] = '';
	}
	
	return $limit == 1 ? $data[0] : $data;
}

function go404 (){
	header("Location: ".HTML_SITE.'/404');
}

function realEscape($s) {
	if(get_magic_quotes_gpc()) {
		$s = stripslashes($s);
	}
	return mysql_real_escape_string ( strip_tags($s) );
}

function doCurl ($url){
	
	$curl = curl_init();
	
	if (FALSE === $curl)
		throw new Exception('failed to initialize');

	curl_setopt ($curl, CURLOPT_URL, $url);
	curl_setopt ($curl, CURLOPT_RETURNTRANSFER, true);
	curl_setopt ($curl, CURLOPT_CAINFO, dirname(__FILE__)."/cacert.pem");
	
	$str = curl_exec($curl);

	if(str === false)
		return '';

	curl_close($curl);
	
	return $str;
}

function reverseSlug ($s){
  return str_replace ('-',' ', $s);
}

function makeSlug ($s){
	$s = preg_replace('/\W+/','-',$s);
	$s = preg_replace('/[^A-Za-z0-9-]+/', '-', $s);
	return strtolower($s);
}
function makeHashtag ($s){
	$s = preg_replace('/\W+/','',$s);
  $s = preg_replace('/[^A-Za-z0-9_]+/', '', $s);
  return $s;
}

function echoV ( $input, $array_keys='', $return='' ){
	// will take keys up to 2 levels only
  if ( $array_keys && is_array ($input) ){
		$output = '';
		$keys = '';
		if ( is_string ($array_keys) ){
			$keys = explode(',', $array_keys);
		}
		if ( isset($keys[0]) ){
			$keyOne = $keys[0];
			$output = isset ($input[$keyOne]) ? $input[$keyOne] : '';
		}
		if ( isset($keys[1]) ){
			$keyTwo = $keys[1];
			$output = isset ($input[$keyOne][$keyTwo]) ? $input[$keyOne][$keyTwo] : '';
		}
	}
  else
    $output = isset ($input) ? $input : '';  
    
  if ( $return ){
    return stripslashes($output);
  }
  else
    echo stripslashes($output);
}

function checkVideo ($videoSource, $videoUrl){
  
  $output = '';
  if ( isset ($videoUrl) && !empty ($videoUrl) ){
    $regYoutube = "/^.*((youtu.be\/)|(v\/)|(\/u\/\w\/)|(embed\/)|(watch\?))\??v?=?([^#\&\?]*).*/";
    $regVimeo = "/^.*(vimeo\.com\/)((channels\/[A-z]+\/)|(groups\/[A-z]+\/videos\/))?([0-9]+)/";
    $output = 0;
    
    if ( $videoSource == 'youtube' ){
      $output = preg_match( $regYoutube, $videoUrl);
    }
    if ( $videoSource == 'vimeo' ){
      $output = preg_match( $regVimeo, $videoUrl);
    }
  }
  
  return $output;
}

function codeRand( $len = 0 ){
  if( $len < 1 ) $len = 5;
  $a = 'abcdefghijklmnopqrstuvwxyz1234567890';
  $c = $a[rand(0, 25)];
  for($i=0; $i< $len-1; $i++) { $c .= $a[rand(0, 35)]; }
  return $c;
}

function fixMultiFilesArray($file_post) {

  $file_ary = array();
  $file_count = count($file_post['name']);
  $file_keys = array_keys($file_post);

  for ($i=0; $i<$file_count; $i++) {
      foreach ($file_keys as $key) {
          $file_ary[$i][$key] = $file_post[$key][$i];
      }
  }
	if ( count($file_ary) == 1 && $file_ary[0]['name'] == '' && $file_ary[0]['tmp_name'] == '')
		return array();
	else
		return $file_ary;
}
?>