<?php
class MediaState {
	
	public $table;
	public $currentProjectTitle;
	
	public $theGet = array();
	public $globalData = array();
	public $currentPage = array();
	
	public $isRootPage = 0;
	
	public function MediaState(){
		$this->table = new Table();
	}
	
	function processRoute(){
		$this->theGet[1] = isset($_GET['first']) ? realEscape ($_GET['first']) : '';
		$this->theGet[2] = isset($_GET['second']) ? realEscape($_GET['second']) : '';
		$this->theGet[3] = isset($_GET['third']) ? realEscape($_GET['third']) : '';
		
		$this->globalData['currentPageSlug'] = $this->theGet[1];
	}
	function header (){
		$MAIN = $this;
		include ("templates/header.php");
	}
	function footer (){
		$MAIN = $this;
		include ("templates/footer.php");
	}
	function theGet ($index){
		return isset ($this->theGet[$index]) ? $this->theGet[$index] : '';
	}
	function theCurrentPageTitle( $args=array() ){
		$return = isset ($args['return']) ? 1 : 0;
		$output = isset($this->globalData['currentPageSlug']) && !empty($this->globalData['currentPageSlug']) ? ucwords(reverseSlug($this->globalData['currentPageSlug'])) : 'Home';

		// special title for portfolio items
		if ( $this->globalData['currentPageSlug'] == 'portfolio' && $this->theGet(2) != '' ){
			$output = $this->currentProjectTitle;
		}
		
		if ( $return ) return $output;
		else echo $output;
	}
	function theCurrentPageSlug( $args=array() ){
		$return = isset ($args['return']) ? 1 : 0;
		$output = isset($this->globalData['currentPageSlug']) ? $this->globalData['currentPageSlug'] : '';
		
		if ( $return ) return $output;
		else echo $output;
	}
	function getGeneralSetting ($slug, $pageContentName = 'content', $echo = 0){
		if ( $echo == 0 )
			return echoV($this->globalData['general'], $slug.','.$pageContentName, 1);
		else
			echoV($this->globalData['general'], $slug.','.$pageContentName);
	}
	function getTableDataWithSlug ($table){
		$pagesData = array();
		
		$table = realEscape ($table);
		$q = $this->table->findSql("SELECT * FROM `{$table}`");
		
		if ( isset ($q) && !empty($q) ){
			foreach ($q as $row){
				if ( isset ($row['slug']) ){
					$row['link_location'] = isset ($row['link_location']) ? $row['link_location'] : '';
					$locationSlug = ( $row['link_location'] ) ? $this->getLocationSlugFromID ( $row['link_location'] ) : '';
					if ( $locationSlug )
						$pagesData[$row['slug']][$locationSlug] = $row;
					else
						$pagesData[$row['slug']] = $row;
				}
			}
		}
		return $pagesData;
	}
	function getTableDataWithID($table){
		$table = realEscape ($table);
		$q = $this->table->findSql("SELECT * FROM `{$table}`");
		$result = isset($q) && !empty($q) ? $q : array();
		$output = array();
		if ( $result ){
			foreach ($result as $r){
				$output[$r['id']] = $r;
			}
		}
		
		return $output;
	}
	function getTableData($table){
		$table = realEscape ($table);
		$q = $this->table->findSql("SELECT * FROM `{$table}`");
		return isset($q) && !empty($q) ? $q : array();
	}
	
	function checkRequiredFields(){
		// $output = '';
		// $fundAmount = $this->getFundAmount();
		
		// $requiredFields = ['title','description', 'category', 'budget', 'location'];
		// $coverPhoto = isset ( $_FILES['cover_photo']['tmp_name'] ) && !empty( $_FILES['cover_photo']['tmp_name'] ) ? $_FILES['cover_photo']['tmp_name'] : '';
		// $gallery = fixMultiFilesArray ( $_FILES['photo_gallery'] );
		
		// foreach ( $requiredFields as $req){
			// if (empty ($_POST[$req]) ){
				// $cleanField = ucwords(str_replace("_"," ", $req));
				// $output = $cleanField.' is required.';
			// }
			// elseif ( $output == '' && isset( $_POST['category'] ) && trim($_POST['category']) == '' ){
				// $output = 'Please select a category for your project.';
			// }
			// elseif ( $output == '' && isset( $_POST['budget'] ) &&
					// ( intval($_POST['budget']) <=0 || intval($_POST['budget']) > $fundAmount ) )
			// {
				// $output = 'Please add a budget between $1 and $'.$fundAmount.'.';
			// }
			// elseif ( !$coverPhoto ){
				// $output = 'Please upload a cover photo';
			// }
			// elseif ( count ($gallery) > 3 ){
				// $output = 'You can upload up to 3 gallery photos only';
			// }
		// }
		
		return $output;
	}

	function getQuery($query){
		$q = $this->table->findSql ($query);
		return isset($q) && !empty($q) ? $q : array();
	}
	
	function updateTbl ($table, $args, $where){
		if ( !empty($args) ){
			$table = realEscape ($table);
			$sql = "UPDATE {$table} SET ";
			foreach ($args as $field_k=>$field_v){
				$field_k = realEscape ($field_k);
				$field_v = realEscape ($field_v);
				
				$sql .= "`{$field_k}`='{$field_v}',";
			}
			$sql = rtrim($sql, ',');
			$sql .= " WHERE {$where}";
			$this->table->findSql ($sql);
		}
	}
	function insertToTbl ($table, $args){
		if ( !empty($args) ){
			$table = realEscape ($table);
			$sql = "INSERT INTO {$table} SET ";
			foreach ($args as $field_k=>$field_v){
				$field_k = realEscape ($field_k);
				$field_v = realEscape ($field_v);
				
				$sql .= "`{$field_k}`='{$field_v}',";
			}
			$sql = rtrim($sql, ',');
			$this->table->findSql ($sql);
			return $this->table->adodb->Insert_ID();
		}
	}
	
	function getHomepageData(){
		return $this->getTableDataWithSlug("homepage_data");
	}

	function getHomeGallery($args=array()){
		$limit = isset($args['limit']) ? 'LIMIT '.realEscape($args['limit']) : '';
		$offset = isset($args['offset']) && $args['offset'] > 0 ? "OFFSET ".intval($args['offset']) : '';
		
		$q = $this->table->findSql("SELECT * FROM `home_gallery` {$limit} {$offset}");
		return isset($q) && !empty($q) ? $q : array();
            }
	function getAboutPageData(){
		$q = $this->table->findSql("SELECT * FROM `page_about` LIMIT 1");
		return isset($q) && !empty($q) ? reset($q) : array();
	}
	function getPageData(){
		return $this->getTableDataWithSlug("pages");
	}
	function getClients($args=array()){
		$limit = isset($args['limit']) ? 'LIMIT '.realEscape($args['limit']) : '';
		$offset = isset($args['offset']) && $args['offset'] > 0 ? "OFFSET ".intval($args['offset']) : '';
		
		$q = $this->table->findSql("SELECT * FROM `clients` {$limit} {$offset}");
		return isset($q) && !empty($q) ? $q : array();
	}
	function getProjects($args=array()){
		$limit = isset($args['limit']) ? 'LIMIT '.realEscape($args['limit']) : '';
		$q = $this->table->findSql("SELECT * FROM `projects` ORDER BY `pos` ASC {$limit}");
		return isset($q) && !empty($q) ? $q : array();
	}
	function getServices($args=array()){
		$limit = isset($args['limit']) ? 'LIMIT '.realEscape($args['limit']) : '';
		$q = $this->table->findSql("SELECT * FROM `services` ORDER BY `pos` ASC {$limit}");
		return isset($q) && !empty($q) ? $q : array();
	}
	function getMembers($args=array()){
		$limit = isset($args['limit']) ? 'LIMIT '.realEscape($args['limit']) : '';
		$where = isset($args['isKeyMember']) ? "WHERE `is_key_member` ='1'" : '';
		$q = $this->table->findSql("SELECT * FROM `members` {$where} ORDER BY `pos` ASC {$limit}");
		return isset($q) && !empty($q) ? $q : array();
	}
	function getNews($args=array()){
		$limit = isset($args['limit']) ? 'LIMIT '.realEscape($args['limit']) : '';
		$offset = isset($args['offset']) && $args['offset'] > 0 ? "OFFSET ".intval($args['offset']) : '';
		
		// $where = isset($args['isKeyMember']) ? "WHERE `is_key_member` ='1'" : '';
		$q = $this->table->findSql("SELECT * FROM `news` ORDER BY `pos` ASC {$limit} {$offset}");
		return isset($q) && !empty($q) ? $q : array();
	}
	function checkProjectDetails($args=array()){
		$output = array('status'=>0, 'data'=>array());
		
		$projectID = isset($args['project']) && !empty($args['project']) ? realEscape($args['project']) : 0;
		
		if ( $projectID > 0 ){
			$q = $this->table->findSql ("SELECT * FROM `projects` WHERE `id` = '{$projectID}' LIMIT 1") ;
			if ( isset($q) && !empty($q) ){
				$output['status'] = 1;
				$output['data'] = reset($q);
				$this->currentProjectTitle = $output['data']['title'].' '.$output['data']['title_secondary'];
			}
		}
		return $output;
	}
	function getProjectDetails($args=array()){
		$requestFromAjax = isset($args['ajax']) ? 1 : 0;
		$projectData = isset($args['data']) && !empty($args['data']) ? $args['data'] : array();
		$projectID = isset($projectData['id']) && !empty($projectData['id']) ? realEscape($projectData['id']) : 0;
		
		$_DATA = array('projectGallery'=>array(), 'data'=>$projectData, 'output'=>'');

		if ( $projectID > 0 ){
			$q = $this->table->findSql ("SELECT * FROM `projects_gallery` WHERE `link_project` = '{$projectID}'  ORDER BY `pos`");
			if ( isset ($q) && !empty($q) ){
				$_DATA['projectGallery'] = $q;
			}
		}
		ob_start();
		if ( $requestFromAjax ){
			include ('../templates/portfolio-details.php');
		}
		else{
			include ('templates/portfolio-details.php');
		}
			
		$_DATA['output'] = ob_get_contents();
		ob_end_clean();
		
		return $_DATA['output'];
	}
}
?>