<?php
    require_once('common/header.php');
    $table = new Table();
    $allEditableTables = $table->listAllEditableTables();



    foreach ($allEditableTables as $tableName){
        $tempTable = new Table($tableName);
        $parentTable = $tempTable->getRootTable($tableName);
        if(empty($parentTable)){
            $parentTable = $tableName;
        }
        $parentTables [] = $parentTable;
    }
    //Keep only unique values
    $parentTables = array_unique($parentTables);

?>
<div class="sitemap">
    <h1 class="title">Site map</h1>
    <hr />
    <?php

        $options = array (
            'options' => array (
                'limit' => 5
            )
        );

        foreach($parentTables as $tableName){
            if(TableTraversal::beenVisited($tableName)){
                continue;
            }
            echo '<div class="table">';
            echo '<h2 style="cursor:pointer" onclick="window.location.href=\'' . pageLink('list.php?table='.$tableName) . '\'">'.printTableName($tableName).' <span style="font-size:14px">[ <a href="'.pageLink('generate.php?table='.$tableName).'">+</a> ]</span></h2>';
            $menu = TableTraversal::createMenu($tableName,$options);
            drawSiteMapMenu($menu);
            echo '</div>';
        }
    ?>
</div>

<div id="loadMoreModal">
    <form action="<?php echo ''. ADMIN_PATH_HTML.DS.'actions'.DS.'loadMoreSitemap.php' .''; ?>" method="post" class="loadMoreForm">
        <label>Number of records to load. (0 for all)<br /><br />
            <input type="text" name="count" value="0" />
        </label>
        <br /><br />
        <label>Order by<br /><br />
            <select name="order_by" class="orderBySelect">
                <option value="">Please select a column to order the results by</option>
            </select>
        </label><br /><br />
        <input type="hidden" name="tableName" />
        <input type="hidden" name="foreignKey" />
        <input type="hidden" name="foreignKeyId" />

        <input type="submit" value="Load..." class="loadMoreSubmit" />
    </form>
</div>
<?php
    /*
    IMAGE POP
    */
    include(ADMIN_PATH.DS."plugins".DS."imagepop.php");
?>
<style type="text/css">
    .sitemap ul{
        margin-left:20px;
    }
    .sitemap ul.parentMenu {
        margin-bottom:20px;
    }
    .sitemap .table{
        padding:10px; background-color:#FFF;
        margin-bottom:10px;
    }
</style>
<?php require_once('common/footer.php'); ?>