<?php
    require_once('common/header.php');
    $log = new Log();
    $allLogs = $log->findAll(0);
    $stats = new Statistics(false);

?>
<h1 class="title">Admin History Logs</h1>
<div class="form round drop_shadow">


    <table cellpadding="0" cellspacing="0" border="0" class="display" id="example" style="width:98%">
        <thead>

            <tr >
                <th><h2>Date</h2></th>
                <th><h2>User</h2></th>
                <th><h2>Action</h2></th>
            </tr>
        </thead>
        <tbody class="content">
            <?php foreach($allLogs as $log) :?>
            <tr height="25">
                <td width="25%"><?php echo date("F j, Y, g:i a",strtotime($log['time'])); ?></td>
                <td width="10%"><?php echo $log['username']; ?></td>
                <td><?php echo ucfirst($log['action']); ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
    <div class="clear"></div>
</div>

<script>
    $(document).ready(function(){
            $("#example").dataTable({
        "aoColumns": [
            { "asSorting": [ "desc", "asc" ] }, //first sort desc, then asc
        ]
    } );
    });
</script>



<?php require_once('common/footer.php'); ?>