<?php
    require_once('common/header.php');
    if(!empty($_GET['table'])){
        $tableName = $_GET['table'];
    }else{
        die("Please select a table!");
    }
    $table = new Table($tableName);
    $totalRows  = $table->countAllRows();//Total number of entries
    //Pagination
    $page = !empty($_GET['page']) ? (int)$_GET['page'] : 1;
    $perPage = PER_PAGE;
    $maxPages = ceil($totalRows/$perPage);//maximum number of pages that could be returned
    $pagination = new Pagination($page,$perPage,$totalRows);


    $allRows    = $table->listAllRows($pagination->offset(),$perPage);
    //If no data is found, redirect to add new data
    if(empty($allRows)){
        redirect_to("generate.php?table=".$tableName);
    }
    $allFields = $table->getTableFields();

    //Delete IDs
    if(!empty($_POST['delete'])){
        $table->deleteRows($_POST['ids']);
        die;

    }

?>
<form action="<?php echo pageLink('actions/delete.php'); ?>" method="post" enctype="multipart/form-data">
    <h1 class="title">Listing all Entries</h1>
    <div class="form round drop_shadow" id="list">
        <table cellpadding="4" width="100%" style="font-size:12px;">
            <thead class="content">
                <tr class="ui-state-disabled">
                    <?php
                        foreach($allFields as $fieldName):
                            //Do not display position
                            if($fieldName == 'pos'){
                                continue;
                            }
                        ?>

                        <td><h2><?php echo printTableName($fieldName); ?></h2></td>
                        <?php endforeach; ?>
                    <td><h2>Edit</h2></td>
                    <td align="center">
                        <input type="checkbox" id="select-all" />
                    </td>
                </tr>
            </thead>
            <tbody class="content">
                <?php foreach($allRows as $row) : ?>
                    <tr height="30" style="border-bottom:thin solid #eeeee1;line-height:30px;" id="sort_<?php echo $row['id']; ?>">
                        <?php foreach ($row as $fieldName => $value):
                                //Do not display position
                                if($fieldName == 'pos'){
                                    continue;
                                }

                                $fieldType = $table->returnFieldType($fieldName);
                                if($fieldType == 'foreign'){
                                    $row[$fieldName] = $table->getForeignKeyValue($row[$fieldName],$fieldName);
                                }elseif($fieldType == 'checkbox'){
                                    $row[$fieldName] = $row[$fieldName]==1 ? 'Yes' : 'No';
                                }
                                $fieldValue = substr(strip_tags($row[$fieldName]),0,100);

                            ?>
                            <td ><?php echo $fieldValue; ?></td>
                            <?php endforeach; ?>
                        <td width="30"><a href="<?php echo pageLink('generate.php?table='.$tableName.'&id='.$row['id']); ?>"><img src="<?php echo ADMIN_PATH_HTML;?>/images/file_edit.png" width="20" alt="Edit" /></a></td>
                        <td  align="center">

                            <input type="checkbox" name="ids[]" value="<?php echo $row['id']; ?>" />
                        </td>

                    </tr>
                    <?php endforeach; ?>
            </tbody>
        </table><br>


        <?php echo $pagination->displayPagination(); ?>
        <div class="clear"></div>
        <div class="clear"></div>
        <br />
        <?php if(!in_array($tableName,$oneRowTables) && $table->isCrudEnabled()) :  ?>
            <input type="hidden" name="table" value="<?php echo $tableName; ?>" />
            <input class="submit round drop_shadow"  type="button" value="Add" ONCLICK="window.location.href='<?php echo pageLink('generate.php?table='.$tableName);?>'"  style="float:left;margin-left:4px;" />

            <input type="submit" id="delete" name="delete" class="submit round drop_shadow" value="Delete" style="float:left;margin-left:4px;" />

            <input class="submit round drop_shadow" type="button" value="Inverse" id="inverse" style="float:left;margin-left:4px;" />
            <?php endif; ?>

        <div class="clear"></div>
    </div>

</form>


<form action="<?php echo pageLink('actions/delete.php'); ?>" method="post" enctype="multipart/form-data">
    <h1 class="title">Listing all Entries</h1>
    <div class="form round drop_shadow" id="list">
        <table cellpadding="0" cellspacing="0" border="0" class="display" id="example" style="width:980px">
            <thead>

                <tr class="ui-state-disabled">
                    <?php
                        foreach($allFields as $fieldName):
                            //Do not display position
                            if($fieldName == 'pos'){
                                continue;
                            }
                        ?>

                        <th><?php echo printTableName($fieldName); ?></th>
                        <?php endforeach; ?>
                    <th>Edit</th>
                    <th align="center">
                        <input type="checkbox" id="select-all" />
                    </th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($allRows as $row) : ?>
                    <tr height="30" style="border-bottom:thin solid #eeeee1;line-height:30px;" id="sort_<?php echo $row['id']; ?>">
                        <?php foreach ($row as $fieldName => $value):
                                //Do not display position
                                if($fieldName == 'pos'){
                                    continue;
                                }

                                $fieldType = $table->returnFieldType($fieldName);
                                if($fieldType == 'foreign'){
                                    $row[$fieldName] = $table->getForeignKeyValue($row[$fieldName],$fieldName);
                                }elseif($fieldType == 'checkbox'){
                                    $row[$fieldName] = $row[$fieldName]==1 ? 'Yes' : 'No';
                                }
                                $fieldValue = substr(strip_tags($row[$fieldName]),0,100);

                            ?>
                            <td ><?php echo $fieldValue; ?></td>
                            <?php endforeach; ?>
                        <td width="30"><a href="<?php echo pageLink('generate.php?table='.$tableName.'&id='.$row['id']); ?>"><img src="<?php echo ADMIN_PATH_HTML;?>/images/file_edit.png" width="20" alt="Edit" /></a></td>
                        <td  align="center">

                            <input type="checkbox" name="ids[]" value="<?php echo $row['id']; ?>" />
                        </td>

                    </tr>
                    <?php endforeach; ?>
            </tbody>
        </table><br />
          <?php echo $pagination->displayPagination(); ?>
        <div class="clear"></div>
        <div class="clear"></div>
        <br />
        <?php if(!in_array($tableName,$oneRowTables) && $table->isCrudEnabled()) :  ?>
            <input type="hidden" name="table" value="<?php echo $tableName; ?>" />
            <input class="submit round drop_shadow"  type="button" value="Add" ONCLICK="window.location.href='<?php echo pageLink('generate.php?table='.$tableName);?>'"  style="float:left;margin-left:4px;" />

            <input type="submit" id="delete" name="delete" class="submit round drop_shadow" value="Delete" style="float:left;margin-left:4px;" />

            <input class="submit round drop_shadow" type="button" value="Inverse" id="inverse" style="float:left;margin-left:4px;" />
            <?php endif; ?>

        <div class="clear"></div>
    </div>
</form>
<script>
    $(document).ready(function(){
            $("#example").dataTable();
    });
</script>
<?php if($table->isTableSortable()) : ?>
    <script type="text/javascript">

        $(document).ready(function() {
                $("#list tbody.content").sortable({opacity: 0.6, cursor: 'move',items: "tr:not(.ui-state-disabled)",helper: function(e, tr)
                        {
                            var $originals = tr.children();
                            var $helper = tr.clone();
                            $helper.children().each(function(index)
                                {
                                    // Set helper cell sizes to match the original sizes
                                    $(this).width($originals.eq(index).width())
                            });
                            return $helper;
                        },update: function() {
                            var order = $(this).sortable("serialize") + '&action=updateRecordsListings&table=<?php echo $tableName; ?>&page=<?php echo $page; ?>';
                            $.post("../actions/order.php", order, function(theResponse){
                                    $("#saveResult").html(theResponse);
                                    $("#saveResult").hide();
                                    $("#saveResult").html("<div class='response_class'>Rows order updated</div>");
                                    $('#saveResult').fadeIn('slow').delay(2000).fadeOut("fast");
                            });
                        }
                });
                $("#list tbody.content").disableSelection();
        });

    </script>
    <style type="text/css">
        #list tr:not(.ui-state-disabled){
            cursor:move;
        }
    </style>
    <?php endif; ?>
<?php require_once('common/footer.php'); ?>