<?php
    require_once('common/header.php');
    if(!empty($_GET['table'])){
        $tableName = $_GET['table'];
    }else{
        die("Please select a table!");   
    }
    $table = new Table($tableName);
    $allRows = $table->listAllRows();
    //If no data is found, redirect to add new data
    if(empty($allRows)){
        redirect_to("generate.php?table=".$tableName);   
    }
    $allFields = $table->getTableFields();
    unset($allFields[0]); //Shift the ID to the last index, for design purposes
    $allFields[] = 'id';
    
    //Delete IDs
    if(!empty($_POST['delete'])){
        $table->deleteFields($_POST['ids']);
        $session->message("Deleted records!"); 
        redirect_to("list.php?table=".$tableName);
    }

?>
<form action="list.php?table=<?php echo $tableName; ?>" method="post" enctype="multipart/form-data">
    <h1 class="title">Listing all Entries</h1>
    <div class="form round drop_shadow" id="list"> 
    
    
        <?php foreach($allFields as $fieldName): ?>
            <div class="column_title" style="<?php echo $fieldName == 'id' ? 'margin-left:30px;':''; ?>">
                <h2><?php echo $fieldName == 'id' ? 'Edit' : printTableName($fieldName); ?><?php if($fieldName == 'id'):?>
                        &nbsp; <input type="checkbox" id="select-all" style="margin-left:9px;" />
                    <?php endif; ?></h2>

                <?php foreach($allRows as $row) : ?>
                    <?php if($fieldName == 'id'): ?>
                        <div class="column">
                            <input type="checkbox" name="ids[]" value="<?php echo $row[$fieldName]; ?>" style="margin-top:5px;" />
                            <a href="generate.php?table=<?php echo $tableName; ?>&id=<?php echo $row['id']; ?>"><div class="submit round drop_shadow" style="padding:5px;margin-right:10px;text-align:center; width:auto;min-width:0; float: left;">EDIT</div></a>
                        </div>
                        <?php continue; endif; ?>
                    <?php 
                        $fieldType = $table->returnFieldType($fieldName);
                        if($fieldType == 'foreign'){
                            $row[$fieldName] = $table->getForeignKeyValue($row[$fieldName],$fieldName);  
                        }elseif($fieldType == 'checkbox'){
                            $row[$fieldName] = $row[$fieldName]==1 ? 'Yes' : 'No';   
                        }
                        $fieldValue = substr(strip_tags($row[$fieldName]),0,100);
                    ?>
                    <div class="column"><?php echo !empty($fieldValue) ? $fieldValue : ' - '; ?></div>

                    <?php endforeach; ?>

            </div>
            <?php endforeach; ?>
        <div class="clear"></div>
        <br />
        <input class="submit round drop_shadow"  type="button" value="Add" ONCLICK="window.location.href='generate.php?table=<?php echo $tableName;?>'"  style="float:left;margin-left:4px;" />
       
        <input type="submit" name="delete" class="submit round drop_shadow ConfirmDelete" value="Delete" style="float:left;margin-left:4px;" />
        
         <input class="submit round drop_shadow" type="button" value="Inverse" id="inverse" style="float:left;margin-left:4px;" />
        
        <div class="clear"></div>
    </div>
   </form>

<?php require_once('common/footer.php'); ?>