<?php
    require_once('../../server/api-adodb/config.php');
    require_once(LIB_PATH.DS.'user.class.php');
    require_once(LIB_PATH.DS.'session.class.php');

    if (isset($_POST) && !empty($_POST)) { // Form has been submitted.
        $username = $_POST['username'];
        ##Check if the username exists ##
        if($lookUpUser = User::find_by_user($username)){

            ##If the user is trying to verify his account ##
            if(!empty($_POST['verification'])){
                $verificationKey = $_POST['verification'];
                if($verificationKey == $lookUpUser->verification){

                    //Generate a random password
                    $password = randomPassword();
                    $lookUpUser->password = User::cryptPassword($password);
                    //Reset the verification key, for security reasons
                    $lookUpUser->verification = "";
                    //Update the user's information in the database
                    $lookUpUser->save();
                    $session->message("Your new password is now: <b style='color:#000;'>".$password."</b><br /><br />");
                    redirect_to("login.php");
                }
            }

            $userEmail = $lookUpUser->email;
            ## Check if the user has a valid email inside the database ##
            if(!validMail($userEmail)){
                $resultMessage = 'You have no email address input. Please contact the website administrator to help you further.';
            }else{
                if(empty($lookUpUser->verification)){
                    //Generate a random verification key
                    $verificationKey = md5(rand(0,time()));
                    $lookUpUser->verification = $verificationKey;
                    $lookUpUser->save();
                }
                //email the user his verification code
                $message = 'Your verification code is: '.$lookUpUser->verification;

                //Load the email from, from the database
                $site = new Site();
                $email_from = $site->contact_email;

                $headers = 'From: '.'No-Reply'.' <'.$email_from.">\r\n".
                'Reply-To: '.$email_from."\r\n" .
                'X-Mailer: PHP/' . phpversion()."\r\n";
                $headers .= "MIME-Version: 1.0\r\n";
                $headers .= "Content-Type: text/html; charset=ISO-8859-1\r\n";

                if(@mail($userEmail,'Admin Area Password',$message)){
                    $resultMessage = 'We have sent an email to '.$userEmail.' with a verification code that you input in this page.';
                }else{
                    $resultMessage = 'There was an error emailing you the verification key.';
                }

            }
        }else{
            $resultMessage = 'User is not found!';
        }

    }


?>
<!DOCTYPE>
<html>
    <head>
        <title>Forgot My Password</title>
        <link href="<?php echo ADMIN_PATH_HTML.DS; ?>css/styles.css" media="all" rel="stylesheet" type="text/css" />
        <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML.DS; ?>js/jquery.js"></script>
        <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML.DS; ?>js/actions.js"></script>
        <script type="text/javascript" src="<?php echo ADMIN_PATH_HTML.DS; ?>js/scripts.js"></script>
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    </head>
    <body style="background-image:url('images/smoke.png'); background-position: top center"><br><br><br>
        <div style="width:217px; margin:0 auto;padding-bottom:20px;padding-top:20px;">
            <img src="images/logo-outside.png" />
        </div>
        <div id="loginPage" class="round" style="padding:10px;margin:0 auto;text-align:center; width:300px;">
            <form action="" method="post">

                <?php echo $resultMessage; ?>
                <br /><br />
                <input type="text" name="username" placeholder="Username" class="inputLogin" /><br><br>
                <input type="text" name="verification" placeholder="Verification Key" class="inputLogin" /><br><br>
                <input class="submit round drop_shadow" type="submit" name="forgot_password" style="background-color: #fff; color:#383838; border: 0; font-size:11px;" value="Forgot Password" />
            </form>
        </div>
    </body>
</html>