<?php
    require_once('common/header.php');
    $log = new Log();
    $allLogs = $log->findAll();
    $stats = new Statistics(false);
?>
<h1 class="title">Admin History Logs</h1>

<div class="form round drop_shadow">
    <table cellpadding="4" width="100%" style="font-size:12px;" class='coolTable'>
        <tr>
            <td width="17%"><h1 class='title blue'>Date</h1></td>
            <td width="24%"><h1 class='title green'>User</h1></td>
            <td><h1 class='title orange'>Action</h1></td>
        </tr>
        <?php foreach($allLogs as $log) :?>
            <tr height="25">
                <td><?php echo date("F j, Y, g:i a",strtotime($log['time'])); ?></td>
                <td><?php echo $log['username']; ?></td>
                <td><?php echo ucfirst($log['action']); ?></td>
            </tr>
            <?php endforeach; ?>

        <tr>
            <td colspan="3" style="text-align: right;">
                <a href="<?php echo ADMIN_PATH_HTML.DS; ?>logs.php">+ View All</a>
            </td>
        </tr>
    </table>
</div>
<br />
<h1 class="title">Statistics</h1>
<div class="form round drop_shadow">
    <table cellpadding="4" width="100%" style="font-size:12px;" class="coolTable">
        <tr>
            <td width="17%"><h1 class='title blue'>Date</h1></td>
            <td width='24%'><h1 class='title green'>Unique visitors</h1></td>
            <td><h1  class='title orange'>Pageviews</h1></td>
        </tr>
        <?php for($i=0;$i<=7;$i++) :
                $date = date('Y-m-d', strtotime("-$i day"));
                $uniqueVisitors = $stats->uniqueVisitors($date);
                $pageViews = $stats->pageViews($date);
                $displayDate = date("d F, Y", strtotime($date));
            ?>
            <tr height="25">
                <td><?php echo $displayDate; ?></td>
                <td><?php echo $uniqueVisitors; ?> unique visitor<?php echo $uniqueVisitors == 1 ? '' : 's'; ?></td>
                <td><?php echo $pageViews; ?> pageview<?php echo $pageViews == 1 ? '' : 's'; ?></td>
            </tr>
            <?php endfor; ?>
        <tr>
            <td colspan="3" style="text-align: right;">
                <a href="<?php echo ADMIN_PATH_HTML.DS; ?>stats.php">+ View All</a>
            </td>
        </tr>
    </table>
    </div>

<?php require_once('common/footer.php'); ?>