<?php

/*  PEL: PHP Exif Library.  A library with support for reading and
 *  writing all Exif headers in JPEG and TIFF images using PHP.
 *
 *  Copyright (C) 2005, 2006  Martin Geisler.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program in the file COPYING; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
 *  Boston, MA 02110-1301 USA
 */

/* $Id$ */

/* Autogenerated by the make-image-test.php script */


class pentax_istDS extends UnitTestCase {

  function __construct() {
    require_once('../src/PelJpeg.php');
    parent::__construct('PEL pentax-istDS.jpg Tests');
  }

  function testRead() {
    Pel::clearExceptions();
    Pel::setStrictParsing(false);
    $jpeg = new PelJpeg(dirname(__FILE__) . '/pentax-istDS.jpg');

    $exif = $jpeg->getExif();
    $this->assertIsA($exif, 'PelExif');

    $tiff = $exif->getTiff();
    $this->assertIsA($tiff, 'PelTiff');

    /* The first IFD. */
    $ifd0 = $tiff->getIfd();
    $this->assertIsA($ifd0, 'PelIfd');

    /* Start of IDF $ifd0. */
    $this->assertEqual(count($ifd0->getEntries()), 13);

    $entry = $ifd0->getEntry(271); // Make
    $this->assertIsA($entry, 'PelEntryAscii');
    $this->assertEqual($entry->getValue(), 'PENTAX Corporation ');
    $this->assertEqual($entry->getText(), 'PENTAX Corporation ');

    $entry = $ifd0->getEntry(272); // Model
    $this->assertIsA($entry, 'PelEntryAscii');
    $this->assertEqual($entry->getValue(), 'PENTAX *ist DS     ');
    $this->assertEqual($entry->getText(), 'PENTAX *ist DS     ');

    $entry = $ifd0->getEntry(274); // Orientation
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 1);
    $this->assertEqual($entry->getText(), 'top - left');

    $entry = $ifd0->getEntry(282); // XResolution
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 => 72,
  1 => 1,
));
    $this->assertEqual($entry->getText(), '72/1');

    $entry = $ifd0->getEntry(283); // YResolution
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 => 72,
  1 => 1,
));
    $this->assertEqual($entry->getText(), '72/1');

    $entry = $ifd0->getEntry(296); // ResolutionUnit
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 2);
    $this->assertEqual($entry->getText(), 'Inch');

    $entry = $ifd0->getEntry(305); // Software
    $this->assertIsA($entry, 'PelEntryAscii');
    $this->assertEqual($entry->getValue(), '*ist DS     Ver 1.00   ');
    $this->assertEqual($entry->getText(), '*ist DS     Ver 1.00   ');

    $entry = $ifd0->getEntry(306); // DateTime
    $this->assertIsA($entry, 'PelEntryTime');
    $this->assertEqual($entry->getValue(), 1106749970);
    $this->assertEqual($entry->getText(), '2005:01:26 14:32:50');

    $entry = $ifd0->getEntry(318); // WhitePoint
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 =>
  array (
    0 => 313,
    1 => 1000,
  ),
  1 =>
  array (
    0 => 329,
    1 => 1000,
  ),
));
    $this->assertEqual($entry->getText(), '313/1000, 329/1000');

    $entry = $ifd0->getEntry(319); // PrimaryChromaticities
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 =>
  array (
    0 => 64,
    1 => 100,
  ),
  1 =>
  array (
    0 => 33,
    1 => 100,
  ),
  2 =>
  array (
    0 => 21,
    1 => 100,
  ),
  3 =>
  array (
    0 => 71,
    1 => 100,
  ),
  4 =>
  array (
    0 => 15,
    1 => 100,
  ),
  5 =>
  array (
    0 => 6,
    1 => 100,
  ),
));
    $this->assertEqual($entry->getText(), '64/100, 33/100, 21/100, 71/100, 15/100, 6/100');

    $entry = $ifd0->getEntry(529); // YCbCrCoefficients
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 =>
  array (
    0 => 299,
    1 => 1000,
  ),
  1 =>
  array (
    0 => 587,
    1 => 1000,
  ),
  2 =>
  array (
    0 => 114,
    1 => 1000,
  ),
));
    $this->assertEqual($entry->getText(), '299/1000, 587/1000, 114/1000');

    $entry = $ifd0->getEntry(531); // YCbCrPositioning
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 2);
    $this->assertEqual($entry->getText(), 'co-sited');

    $entry = $ifd0->getEntry(50341); // PrintIM
    $this->assertIsA($entry, 'PelEntryUndefined');
    $this->assertEqual($entry->getValue(), 'PrintIM 0300   !                      	     
             
       4                                       	    
      D
                           \'    \'    \'  \'  \'  q  \'  x  \'     \'  a  \'    \'                                                                  ');
    $this->assertEqual($entry->getText(), '(undefined)');

    /* Sub IFDs of $ifd0. */
    $this->assertEqual(count($ifd0->getSubIfds()), 1);
    $ifd0_0 = $ifd0->getSubIfd(2); // IFD Exif
    $this->assertIsA($ifd0_0, 'PelIfd');

    /* Start of IDF $ifd0_0. */
    $this->assertEqual(count($ifd0_0->getEntries()), 30);

    $entry = $ifd0_0->getEntry(33434); // ExposureTime
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 => 1,
  1 => 4,
));
    $this->assertEqual($entry->getText(), '1/4 sec.');

    $entry = $ifd0_0->getEntry(33437); // FNumber
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 => 45,
  1 => 10,
));
    $this->assertEqual($entry->getText(), 'f/4.5');

    $entry = $ifd0_0->getEntry(34850); // ExposureProgram
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 2);
    $this->assertEqual($entry->getText(), 'Normal program');

    $entry = $ifd0_0->getEntry(34855); // ISOSpeedRatings
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 200);
    $this->assertEqual($entry->getText(), '200');

    $entry = $ifd0_0->getEntry(36864); // ExifVersion
    $this->assertIsA($entry, 'PelEntryVersion');
    $this->assertEqual($entry->getValue(), 2.21);
    $this->assertEqual($entry->getText(), 'Exif Version 2.21');

    $entry = $ifd0_0->getEntry(36867); // DateTimeOriginal
    $this->assertIsA($entry, 'PelEntryTime');
    $this->assertEqual($entry->getValue(), 1106749970);
    $this->assertEqual($entry->getText(), '2005:01:26 14:32:50');

    $entry = $ifd0_0->getEntry(36868); // DateTimeDigitized
    $this->assertIsA($entry, 'PelEntryTime');
    $this->assertEqual($entry->getValue(), 1106749970);
    $this->assertEqual($entry->getText(), '2005:01:26 14:32:50');

    $entry = $ifd0_0->getEntry(37121); // ComponentsConfiguration
    $this->assertIsA($entry, 'PelEntryUndefined');
    $this->assertEqual($entry->getValue(), ' ');
    $this->assertEqual($entry->getText(), 'Y Cb Cr -');

    $entry = $ifd0_0->getEntry(37380); // ExposureBiasValue
    $this->assertIsA($entry, 'PelEntrySRational');
    $this->assertEqual($entry->getValue(), array (
  0 => 0,
  1 => 10,
));
    $this->assertEqual($entry->getText(), '0.0');

    $entry = $ifd0_0->getEntry(37383); // MeteringMode
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 5);
    $this->assertEqual($entry->getText(), 'Pattern');

    $entry = $ifd0_0->getEntry(37385); // Flash
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 16);
    $this->assertEqual($entry->getText(), 'Flash did not fire, compulsory flash mode.');

    $entry = $ifd0_0->getEntry(37386); // FocalLength
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 => 45,
  1 => 1,
));
    $this->assertEqual($entry->getText(), '45.0 mm');

    $entry = $ifd0_0->getEntry(37500); // MakerNote
    $this->assertIsA($entry, 'PelEntryUndefined');
    $this->assertEqual($entry->getValue(), 'AOC MM H                     \\       	<      *           2           	     "          
                     a      -        	        2                                                            !        "         #        $        %        &        \'     (     )      F +     D  ,         -       2         3       4         5    .3 6        7        :    Ff   =         >       ?       A         G        H         I        O                                $      4    $  D      h	      
            
                                                            	      	      	                 C         p  (  p   `Sj(@   hj @   p(Q(fI`<M|	v*       ?;  i                XXVUTVTYWZWY[Y[V^                                4    ?    9+        9=    !3I    ^-    &*7     *1͢       [@    " z   ] ^ _   Z Z [ [ \\ \\ ]    		
 $.\' "+"(6(+/1343&8<82<.231		


1!!11111111111111111111111111111111111111111111111111 !           
   } !1AQa"q2#BR$3br
%&\'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz       
  w !1AQaq"2B	#3Rbr
$4%&\'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz   ?  ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( (/}#/#W F ҿ "7 ;ϧD] sI O J<9 ϯDH9"? i "?. kI O K ֓ > ƎywH ֑ > ƏF ȏ4{IwH#:GG _Ft ȏ4{IwH Α > ƏF4 ȏ4$C#| # /#G G =$@xcH ? K  > Əi. _G ? K  > Əi. [G ? G"? W =${  > ƏE ȯ4{IwH"? W ?  "%9#_Et ȯ4) ϟE%9"/"?W ?  "%9"h _i  "E4 ȯ4\'<+ /i. OG / G"z? Gp\' ϗE KG / Gp#ω 4 ]Ò"#ω 4#ϗEKrD?  "  >_ Əi. GH ? G"ZG GrDOD~ ƏD Əi.?  OE4 Əi +Ϡ 4+Ϩ 4{I$D [F Q _i?ч G =!  > ƏE_? Əi.?q ?1 ϯDH9" \'#Z/ OKrD?  OFo? ƎywH ލ ><9ϙ 4s˸rDOG4o? ƏG4 ȯ4{Iw$@sG _itq . ƎywH  > ƃ#| + >HG ȏ4i hpi h {I? h.H  > ƃ\'}?# Aֿ Ɠ\'? i9"l)qPXW!Q /?)HZ _$z҈WրBR(i|b֍Hbvj Sҍ( })@_J/E/;
//
>XBzʂ0@^7Ѿ0y7Ѽ\\搹 .}hBրOZJ`!v⒘	E !(
% %\' f% t0	LLҀ I@i`.iE 	  Pis@
.h &h .h  .h  =is 3Z	P@h 4(IQIހ
J (=i~ R CIZ CM!bJ 
\' {Qސi1L" OE !ҀRPR)=iE 4
^ hEAH FhE 
Z hs( 
^ cҚ J:Pi t	Gրސ	
0
oր%N C@E!RP E% J(@i()8 Y.)Q@@/ր@Kր
J (Z :ўh PR Z PK@	J(  R ;Si( I@@	 @-7)RP  JJ LR@zJ!@A4JJ % %
 !PC 4 ޔ
 QJ)) 
p Q@
 R  (=OҌPzKҀ
1Z Z()i )(@	(4LI@9Rb	I@\'ҀQ@	Ғ
B( R`!(0 HxX@
9P :R )h h  
^ Q@K j ( ih - %.3@1E  Rg`&hސ% \'zJ J})Q JCցzJ 
% %&(I@GzC@ %0\'ziHBRS^PZ@uK@ -/A@zZ@R.8sK@ 
\\z@
Z >PJ
 E0R 4J1@\'n RPR )((>)\'zBM0 CE %% PRf	G ?ZLPJ Jiuq@iE - (  Q@
:Q@( R P ((@ PK 
O )8`%	)
 ֐RbIҘ	Hx B(:RPI4 ibsL@=hB}i
 4PQLRE@
8 *(h 
@: )h K@
?Z3 1Z (PF3@- P/j@`vE %\'^ 
 %&h E 4 *:tQ@	CHi
1); y
@i=( >S >%!LBCҀ-QLGQ@K@ @(4 QH)h  P@@ PKրK@Gj 1E /SE @ր
(1@J= f@4 RP184 R JC@P1JOZ% %
4 }zP!
!x;L  R J&
Z ;QH cߊ ZQ@ K@JZ z;(K@  - Qր RvރҘM% QI@	I@RPz? %!bQ@4Ih1)(
!4%!!SEހҖE  R 14~4Z:PMJ _-  ;R ;Q ZZ SI@  Qր
) gzLP qHE0
A@ &4 P1  Z!b
JbhGҀv!>@	Hh(  w4 QҀ4 J( Rh ڐ.qLHK@ҌPZ (4 v ZJ \\@	E )
 &h& FysL(
!fh 4 BRPf	փh4%!4)4xQL(({@	K )hiZ .H94 GN KR )E4  }(sHXPb{u$qdG`N)L x:Piu<"Pe@H^EY$O&1\\DDR3&:D.b7&7+RPfx>}X<P[Mf<V-8n&HdGKaRTnVUߐ0\'iX)7q@\\nzfҟ
f )qL4 3c4 &Қ= RqH#9 6I &}i	2J`] u84PG8>u}<1y0n1#Rhm<1T{љțoKibeiIcNRa=)Xw,O!KyYAT,twcT2tw{*k6,pw`t8=z[w	IbBO[D7
AIl̳|H#4Yжѝdv:H/7vvvj-_B֭T]lfز;fOp@N#NIZfKۼy!bXA4qqV=:9Xs򭧑 %d`ZTY%=OqG(\\+m$>-F9Kvy8"9_J9E9uiZn-CpwUSNէIݡb_$qzf(\\^]KG$x6?MA5ڇfYǰϥ+Ytcm-4\\1LO!O\\;y+l2iؒ#YjK$pV/ջb|#Qxn
 sߚ`t:|Kg[m~5zV\\I#Ǧi!h\\C7%i^SssMMf_9Tʘ
G-4nIǷIJϘFS.B"S$^).]k^q~ 2᧹&mo
:
>MB-L(I!VO\'نݍ$Zחm+K1NZkn#IX(gl;ćO^7# =Y
ܽani%0H^kK)wC\'λovU16v3ҙ/F
+3t	$H4\\\\K::)$Nbm)ݳp:01}aޤ=sOHb)3@r)!yts@sM> `}1HN0
 +ci3(O/ށFTy> ѢҔP ;R
3@z Adm(m?zIBd	$F Nۙ1ʹgZ̙.t#$ܸ%w&alYzj`YssR{y{|=z`)PD&^:"io䵝ŕRvjg%ݥEbB>lc}D\\mR)"{jIN `0*}!`ORLk,REu_Qyf[2Dw>CmMA-RW_)S[?E"B	jPi$d*9,X}ُaƀxlLQIN*KK 9$Бֽ!n&sՏ든CmyTϣflW(\'
|)5K۫[thݳJ㳰٬n켧gRE*iWkHBbTVש,Ȣ	"<x\'sbUY&H$┝!9=NV`}j2K?ec4 `i\\t.^[v́e[5Qt[
Ѻڣ6jiƕy$]ݣ}x~oK6vųu9H]ekqvctޒ
bJIG.y 9dA1$9Jl<dD& JJ.%bYcvc<R豴r*1XQE(YfY%㡩cxmcZd9끎hP}:6yD+ΡX*ql.Kci\\v!9a$;pxPq9ފTsNb)ti<|ߞG6o4!iW9uW 7Qq,hU zR"(j@TfPq@
EE !m mj )67#LbT`B=M##Ld` hQ@J(x) Q@B ڗ dwڧ^ԝAo\\s@Ҁ (ݏ$e{}vq!f,ř4dqMyQC>vy8Hix- GPK1˷=IU._Ooq985
\\lr;R=h촘^h0f+?<X鑑C6ЛuGsq-4ͱ40 FGZA
rl)cҬdgA
J56!ESqmuyձ)?x5ou{lqHɻ${Q6kk}M\'n&:(H\'EK^ԘJz&wԶxySN$		BW6]CQ佷69\\jեMwnBWir3Nˠ}H\'ISSU T/]m^-ʌAvlE(e@p~Up["F
qBQ,_^Y[C9"~zQ{-H|}=[)M] g<;so
L: 2)4qA()
 DX=逇$
m\'> p9 0(9$@6Jk0F2x tZ Ni3M:n/QցE -.h Fi 6n֜ډ[ql 31cqzw{Sio-E23aWޛ#?OҕUԮԌ,p<Qkr!i㕂ɟNfiRZi\\Dq~c
,~fc<ԫ

5墎EtPũ<7)v"\\nScv^u"$>*tHj$,1-=QڕΛyL}9ҖP:9ߺ-2(.b,-J"ifFFjv~} rǹx
yduivb3LYɬ3ȑU,߽ڙ+p.Tqni"OYn5pv>A ~[漙\' nFUf~q,AV3nI^!uė:w38c*Eftû*7p:GPv:=	gvg\'M75K 8$)"@/i6kױN`:Mavk%?c+Kv=GOYž),Ne\'2?SI2idIqU{kpǼxZ#3cldivwszm1t਌\\Mj;+KRVE }Emv)nF
6
BlsOM 3!躚0Y\'xǮhA#E4Di#{0Wo?JEٳ-.h,WOCV4m{VEcLSrFP#ڣ \\H"	ڒ׼VNyq	9Hl>?4[dI2s~r1fmt+YD@ס8HJ>41@ ֑PO9J9a539?1 #*6Lc798aȦ:S bze9"hf )zv(E 2?&8^.{Uung$mT{UrR3GmXf1!Bgh9E2]>KKy^ycv#>M}m3EʮO>MZGt_Lt҇d4Swd+mݎOPlc,6F<wܫ$hO1gi@uʜ4Zgqqy{:<r  c{sNxjȶy0i[98_VuKx)S<M4T6?xq%:\\,wfrP@rZ.,Z-B]dw"ӞK\\v
aۯzWIIab/VWCeВi]qrMh硥Ƿl4qv=
&i`Ys\\w43\\x 7@G{x"My6ބѭxB[y$ޕÕ&m"JzCOz{VmiDqS}hYӭwq,Il}j[XnV00b:RZ-p3.ȨM{an)v֝đ"j|CE v1C[Tś>
$Pr.E CN;hQ6hYa%I(9VDȊ*AUmtYhd}}v-~41` &$x<u p;PLӮPvҀPii ibPiLR@!BRbM4 QҀF9  LPh٥)h  {[tPA6{Isx-̻߻aN¹4,S=yJB}e\\$r	U\'2.Tg=AE I4C,IEUSГѕ2T:/-SOIh`M $lU"R.
LD4jΠgb9A1T皆mF	2΋\'sEjǨǸ6{~\\zfoq+<Qgҝ6R_.y3]jv.\'p+0atpW!PϫZW&@p{Е{	c,!!Um.}3Ku[LddB>+2qc < ܫ8Sb֭$KlGހ~4D:7s4!$`7lpHjwèi$pX/&$Qi$$?\\}jbHgi)`P 	Ю=|Z,e2>/s)[U饂HPCCo[IwV7~3j\\]Bv@/	=XisK3,(`cJuBYǛg;})W4zjrCmb+M Fj?\\\\[DmG&UchKPoFT[nVBυN*V7Y@ѢP#HI»D^7[\\",7nVj70Ď+\\QmG}
OS%H.a?+=E^xkePVerI0(\\][P:K߼p*l 5kEq(NPijZ΢\\FsqnuYHaph?^Y
[ZUh!2Em+;̣zi\\6p,BLҧ׊,̵]<̍u
{rFЊԤ[xCR1ShtbRt"@RPqL% (@E 2tTC?u&-y{NWR:0I"+6\\E>8~y*yQ?b{?l+v9ě;tWZu>s3l0x7%ҧmJ9Aqy¬-2 I)GY-tR>_,7t#SKI
 vQX0gB?yiDr4`Kmi5gdx}:Q
No)ە?jmd2k)mӯFQ=7]؄9tŉW2&lwߥ[X\'R8zbZ4(,,G9^F>hK^R=Ҩ)jL5ٓ\\Or080RFqQyK$bDp1\'$Ni,嵺x%\'XD%QMuiq*E*w#sqO`4MKώ+TmjPK&:!dSԮB]X2!y\'T.HE87͒qOMgo[j#YZ?HNqY\\H6rG_jw4O.e"ٖ--=^oӓ+MOA-ɬI+/^ݞmɧ
.K`aL6zSoˈvk4Ҿ,g]Fd	F:sh,9Wo)}}iV/i6rE<o
ac@I_Vƹb֪ G;Xz:n`S\\ʣzi>Њ4Yv+d:Ӻ2g%2 #JsڃDc3nuk] ewqOӯgXM Tsc.f4hK9cib4d0Kvm_7enÂJ/p
?N+滺h̅6~>I4!1(bJ JC ϥրxR :R  )i 3Ѭ"]IjTӭ

yg})ݓʆ% :NЬr E!%=hc H
NA9
	[5E~Jzl-mt3il3;r:n5.j--lܒެy4\\,-͕A{qJ	WM:Cm䍣](0TP%:^XxJ"Ԏ^qHb\\91) 2:R`N(J2:g8"k\\}dwMibHL*4`d#.FTp qɩљݷ<֍BlWr|a
m-VP\\I9$w:Rb@}(8.ā@56 (01F) xbF,Ȁlr(ؤ(C Gpi1@z(	 zw Zn@
wcAa|d( cLO$q@8<i#8 Pڐ@	@-$Ҙ
x,;Rz^( (4 f4 R6mYQE	ȣ Ya@8Fs*Cdųڋt,@ۚYuWVCj?0{E}DWȉl3,~`;7:Ibaq1@$x:a_TRv/ڦAsā6N:h\\#ʹW!pNֽKi2j76 NQ]fh<ug. /~4P̓¢9%Uo~Z_/j#֝qae!y>LvFtB}j}wyw8+!9;:PՁ2=aƱ,_ 9Ҩ}m\\QL/<K-]kNn1
DV-($Fp1WK,Vi#ғVwe68$C8 ~5
Ԣٚ v"F.4hHs3ƠLP}֭4~#$b ;b(\'CH(Rv S7M s!8> 0֓ Sӊcc`ӵ&pW:PAb)qh2)N6Ҁ3Qzi@ŊR0p0@H~`OpF{P<woipxQ@E .iz}ihG\'s@Hv٭ 7XcF[!&M,[A@f˧4sܖk{{P4Ms`5Ή?vY۞cr2Vrzp%u`v3uw֗YyRgi\\-mONY5@Fݟ{
ٰ{1uU	)E pcE9!n\'$[PK661zno?]XVct幸Cc,ʌ`
:bHz.cmx"xc"J8Y.TiqI3R{Kf@ć#F[.к&&s{\'|"	 U>9e3?%dLiX.s̳i	xr3)hҬsq	\\s;ƍm"ݻ@3iO|Vf~Y{%#Q-y`e ׫
){q@PPzI :ri R OJ(qI@
*8 s@1*1L ؠtJf9* &1@P;s@jҀ
֐(qJ1@4.3 4 J \\z((sLB@K@R( qKB 1qF(G2GPFA-KW5d (Ĵ8R\'SJ( (b њ J) fhH!Abu@	H(Rt\'"@4"`\'Ҋ OjJ JJ JJ 
\'J!4 b)Z;P0 _ vPրt- ԢR^ K Z(ZQ@z(hPRP;R3HzI )	J NԔ;@	I@h1N
C@4ր w=i
 6~Pm0I@	C@04)h K
)  3K!haN pP 揭Fy֔Pњ LZp nd
 \\g41XJ 	AHR>S" 0PN9=I  i,8#g<`0$ԟi<qҝ]TM*!sqQ]`\\LO@O4Y;y iT1($<
=^*FIuWE1&5S=
	\\m[Tzr
EoyĒG#rjNQ JJ )
 %i Z JC@4`QALGցiEK@ 2.vHV #q MhY]%ݪOXwMuzثvqq29 lS`jWq	!m˜})4	Pn<IoZ\\NF3Fi1]6eyY(U^V˶ϾUI	"}Z	cM#RۇY6H; V	}mczo$h	DP+K}>NI㊟NքڤLJɅfǭ;ҽ;PveJWxڕ&h0Vul*SmqKW`@{S[-yTyAgo뎸ϫ.n!y͸`+mZ[9-wlTZ԰\'6אYgKؾ^?=vI&I%wٜhA@/潕̪?g0,K&8@{z2uC.菉LP4k&ѳc$Auiet.YC#7zcw@Jr8sPf.r>;9^S+6R{[!TF-̪}HPnK]jkk\\FYn?(bɬ8Pܰ
K`O_j$MOlK=&,fy81[vw
wcmi8냊NW97ْV.^+IT҃1SbWE8ٕEP>%Ɲ4Pu$VcN(u
:KQ?isI_ldhNj,nwwjȹf?*w7w7
e7sGJ6CA[_g`$#&ҢJ*Ί< >cgGdP8CjR}F̠񚝐Y.L2f1qhk}hvԤŔX*2nutBbL R
%0@cހ
C!4gb> > RZZ XbL`{V"McJ87sHlFx"tW
!|Sb[oDdycBA ` :fOK4ȭRF P-fxHd1ʩ<>=A%s5CFTf[3VtX/oB]F28楖N N}k(MؒC *oct-KV(;W:w&̷s
݁Un2Z)".? 4f[7{޲yc[[d/3dOJ4uG	\'VWODu.K"pjn;:K[VݦVx^jڳ+Aae۳Tؒ)[]ťˉ0U.t$2ܱ?ix#<`gVv/]ך)}`A&N=xdfkd7	\\|Fi2[{<l"ntۓgk
7h^
}Zs)Ief7ϰ"-%2@VyEfcjwLVhtzErVgZE8TwZoJ\'еw@T{Bzr
AgQlp|SRٕoy:ķ{#Aو Ҡm,m"7gi ;k`9`G`F*}:ݭlarP	f
଑4mq)ywhIv"h{ӸU/UKż$QpcZ7֩yi%qZiw3$ү"WqjaU+\\xq=sE CkQ)|u s̷qasvb⋇(hZܤ\'RR:}_ȷ-.q)^J<ѴN$i,U
\\;ev	<Xlf)AX֊I@	E \'zJ`!4JFI@i
 \'zJ%!|њbR KP4 9J:`iHsLy2o]$2C)nGMq$i"#2|q/ڝ@C0K1¨>#R6IsZ,s/,AzSE0Ƞp
- !8f\'?<Ą끓Kwu;m1;*JڪXvi㸂9c?$}
+!84Ekp,Y0x>0 ".VܷKa}=I#
׃v!5R-.$yU{`*մ^[* Ӷ+5cQr΅ϥY7E+ʰ_7a`#5e73 ܯ}x2\\.p_ƳWMÍń=qT=ީ@A\\yeE_ڗ\\Emd%X_n(_Sjt3!%$C;QasT3nM5l[Z	d,&Imy{fPiM%ɵ0LSz|ۃ
^}ܳ.HaCCL}yy4yl	hѷpiY{"ZrGZ}BP2q	¸_Gr<#[<RhVXr0>XwJC  i()( 8BqI CI@T!iz
@PҌ@ΗrP#FjvS9ҩ.I娙Fr|iuUkY T!G[K3-֒m,H#W4{52i0CV]=Gy vNp}.>sa	3w҄2JT#sMei#En Qdf9ԳNbǸjzO \\T;el`\'aOshlgZ+c>mbIIué<KqdkIGj=ƙ./$s$c w,#pAƌ&yNWg"yTws/廔)\'z(FV|6
]Iv;#,mU1#E4ac(7s-zToq0$;9 ޴mkDȬŶsɦ%v-671YY7c`lv	K_si4@lַL n1F*8n;d=u-MvoÞOYek{;c` =M4Xk,t`txt8/7"@ĳ1# z;.O &[1:r3\\
~\'1<Z~B "H㞣N?L!cGEW2h%X@"{EH<)/n խK(`B5TZVCPid=ɚ |x X3>#WU=R	 U;]~"ٮE;C0.:tQ
p~dD;9c#z5Oo5q41)Z`_$ީ#Z-퓪!] wwcP/vIy&%BSzBo<\'.9>Rؔ GԎ6ҺF ,CE !4 )((4 8@4&(ޖ
h@
рEye9[9e)&4;	e̳Y#!vߎ_P)ʖLpO-vWrf۱p
(X\\][́r1U#ҦD	x6vc9JW7fۑ遊K+ktѼYnU9Qp-C.;M*&Cє҆4Eh3#ڟQV.ѐC+U#U4uq!Hj
%r}ql[担q|gmsOu+<sKo&ݍnZ.}ndŻO桗#N1"x`FMYJ+>B"I8*)\\m\\}iH}ԊkjUF \\V2/#b2[D\\*I@}qҋ]Xs42I	ʲ~te{]rI\\aZ]ëeu]$zoV,PDQ.-.b]F.=ME&k/ ~<J.oYJ$H8ݸqi1N%Crp(!ntL[9#?akqnK
iW( +so*"l}~#A@ad=v(G%,B4+pVѮ08#ދM>Yk95ڔmP=ad0Y$ֱE|;b;Ԣ\'6cQp{8-C}
m[ݽًyZ.57Ēr?-C I@3c͉$r ~
ӎ) 1))w% !I@yJ%!"%!hL)~ R kM8VuhhU\\+FdwUORx)7; Hn*9^XP/F4Y8-/4 3HS KR  RR E -% j &h &yPh=((% \'JJ )( 8RS PRR)1LJ CH}hZpR  ր9WμdW(m?a[\\ܨ!Ъ5}+m
D{7z!tSD(>D9|S~l@oЌwBemQ!_)N uPʎ=
J8ڔ8irH4{h )s@ j QҎ(;@	ۭ  AA9<PE \'zL;P04
!I@ J@iPM MCm @	I@\' !	F=hҨB K@ZQր)E+ak<Y`F__C&<ql"dt\\p>Egm&8I]ҕamٌTQrc5sAFhX#D,UUKrHɧH\'ޕhҊ @@>^isH O4 E -@ \' ~4@i( I@ӥ\'nh i(
(% %\' R JJ`P) 
0@!`x4 }ii(AKT!ii f P(gZ(KjC
Ph =hPM h .i f<S R֌@&x4Z Lќf t
Lq@hLJ ;R 
7  PQLIHGz`!C@	ސ6 5B )sH usڊ ( 3ڀrp*QҐ⁉Fh  4 bi ZJ@-  dRP8> fHh (>CӚ3@	GJ CE !@jm PRS( {R);
ހ	M> /Fj/֊ Z(  4.bk-ԟ1 $c]Dn*<v`>4HaSP!7(=
-@Qr0qH	w)ix4 2MVK;"I#?ZPx @
8(@ 4gҐ43I	h4)(4
 (<PM S
% ! RPu4 C CI@	I@4 JN\'֐	)E1
h
(QFi :h&@Fx5;5[z?5"K7iQ+v~=3R7gͳg"91LSR	ޔҾ\\d9\'J0oBg=<.|͜-
#-}I 3\'pnؠ&f{*K~Q`qL[jht3
>rso7dA5onR&rV	"B3jS0H$)Ll7
Fb	2ni;F?1t˒QO= P֔R ~4 Q` A ) gf Lf43E \'z Lj`=(PIڀ
( &֛@ZC@i
 %!BRP i * Pjt O, i%u$țjwGɖfh(Yڭ>\\Qƙo<BdB8F\\450T`Ebn\\2ɼR{WV%\'%6
Hi$DGJki@O__jW	kH2h×bŇiֲy!݌[fȚ+:ǡb]I\'#4]dz5m"U),IjmI{p/SSEbA*$޸RjC4}hR  (GH}iQڐ>( t
:P(v8 CLBR@!
( PRfHzPRP!)
J JC@vB@E "P )Ҁ{P
}is (4:ҊP1i3@ޏ /&E .h3 NS ;Rt (4 GցAJc
Bi wI 4 })( (֊ BE&}h	Ͻ !@\'j\'z
 7E0ڊbKH R Q@
- ()E /Z/ A P 
( ;њ (I@jJ Z)R
@-&iIi( !IL894 Q )( 4 RPR AI@ ;R   ƔU)h    J - (- /Z:R PҊ Q ~ PK@h J( I@);th i }))QH
)4JB:@\'z)vPFh;Q`!Fh% i4 v4 }-P@@
)E -- 4 M NZ3 4 fP1A4 QҀQh Rw4 Q@4g4 Q@ % L0 \'zC
LPI@Rb4P!
%y%  J(3ILE1Җ
Q@zZ ^Ԣ!J : )hHA҂hf@Fy 3E - % Q@AKހ<њ )(  04 R}h 4 i3@  fi	BI` PfL J`>( QHڎ Q@( QK )E!F(v  w \\Ҁ
;@/j ) /z(3A8ڌt ( Ih
By OzLҒM4 (sHh@% J`%% ^y%  @E4 R# J@.hSzP8IҀ>f
( Q Z( @i
 zP LџZ O Qh %
Cր>PG !4 J >3HMJ ^		)4	){SR Z(APҌ  
Q@
9taK@ tFhi) t=4 {Ҁ
9 4fޓ9 ʂ}(3A4ҀIj )(R}h RPJ!484 fJ )( <Q CӚ &h I@!iE KH4 P(Pњ QҔP(4J\\PҌ
;R v h  \\њ J3@3E  ўh &}(Q@i(E MJ LC@i	zPڐQ@i;SZ(
 M K@!h R Z(izv P) ʊ SJ:P1G- Z :Rf
3@ Pߚ;E -R(֊ (4P M44 =(
(ZLN  њ CHi %&( 4zPh@zC@	E %!&.i
 )G }hvE
\\ 
 恎 4}h <PE (@Nf
:PPI@-  4Bh0Rw&i 
3L4	h  @!4 % %Z CE %&h %  Rg Lf@֘ޖ9(Hj3@z :@4@Q@4I Z^ }i>){)qH

3(( w@h& RS lQ )3@&iHM   
&y<P :P \'4 J( T L G$_6 
FG:/~ )H9A Co/? (s!  !P|C Co A 	 ?_
 /~x 	 ?_
H mrH9ZW7 
_H orH9i_ )#ҿ !Q B? ( I  G$ J  K 	& ?_
 I<C]\'C H  G$! 	& ?
 M\'~  x$N? !Q 	& !Q i? )$ !Q I C]\'~  I4 oI CA I  G$O 7 
\\x 	& ?
 I4 C 爿? ( I  KA Iw )?$ !Q I CM\'~  I4 oI CA?$ҳ |7 
_I4 !Q 爇zO 7 
 orH9? ( I  OA?#ҿ !Q 	 ?_
 I<C=+~  zW7 
\\H o_ (s?#ҿ !Q 	 ?_
 I<D J}7 
C-+~>I<C-/~ \'$:W7 
9$Ht mC CoA?!  !Q 	 ?_
I<D> ]6 
? ? !Q.΃K I 	 ??
Ivx$g 6 
O3~tg 6 
?CoA΄? !R{M| 6 
9$ 8I 8G$΃wM qwN qI:8+( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( (ٟ G$O 7 
\\x 	& ?
 I4 C 爿? ( I  KA Iw )?$ !Q I CM\'~  I4 oI CA?$ҳ |7 
_I4 !Q 爇zO 7 
 orH9? ( I  OA?#ҿ !Q 	 ?_
 I<C=+~  zW7 
\\H o_ (s?#ҿ !Q 	 ?_
 I<D J}7 
C-+~>I<C-/~ \'$:W7 
9$Ht mC CoA?!  !Q 	 ?_
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( ?(s?% !Q 	. ?
 $<C]\'~  i  KA%? !Q 	. ?
 I<C]#~  \'$G 7 
=! 	. ?
 It orKs?$ !R? (s?$ !Q 	& ?
 I<CM\'~  \'$zN? !Q I>  /$O7 
9$=\'~  i? (s?# !R\'CA# !RGC GC>"ҿ !Q Ev mi                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZZ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ');
    $this->assertEqual($entry->getText(), '55296 bytes unknown MakerNote data');

    $entry = $ifd0_0->getEntry(40960); // FlashPixVersion
    $this->assertIsA($entry, 'PelEntryVersion');
    $this->assertEqual($entry->getValue(), 1);
    $this->assertEqual($entry->getText(), 'FlashPix Version 1.0');

    $entry = $ifd0_0->getEntry(40961); // ColorSpace
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 65535);
    $this->assertEqual($entry->getText(), 'Uncalibrated');

    $entry = $ifd0_0->getEntry(40962); // PixelXDimension
    $this->assertIsA($entry, 'PelEntryLong');
    $this->assertEqual($entry->getValue(), 1536);
    $this->assertEqual($entry->getText(), '1536');

    $entry = $ifd0_0->getEntry(40963); // PixelYDimension
    $this->assertIsA($entry, 'PelEntryLong');
    $this->assertEqual($entry->getValue(), 1024);
    $this->assertEqual($entry->getText(), '1024');

    $entry = $ifd0_0->getEntry(41495); // SensingMethod
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 2);
    $this->assertEqual($entry->getText(), 'One-chip color area sensor');

    $entry = $ifd0_0->getEntry(41728); // FileSource
    $this->assertIsA($entry, 'PelEntryUndefined');
    $this->assertEqual($entry->getValue(), '');
    $this->assertEqual($entry->getText(), 'DSC');

    $entry = $ifd0_0->getEntry(41729); // SceneType
    $this->assertIsA($entry, 'PelEntryUndefined');
    $this->assertEqual($entry->getValue(), '');
    $this->assertEqual($entry->getText(), 'Directly photographed');

    $entry = $ifd0_0->getEntry(41985); // CustomRendered
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 0);
    $this->assertEqual($entry->getText(), 'Normal process');

    $entry = $ifd0_0->getEntry(41986); // ExposureMode
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 0);
    $this->assertEqual($entry->getText(), 'Auto exposure');

    $entry = $ifd0_0->getEntry(41987); // WhiteBalance
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 1);
    $this->assertEqual($entry->getText(), 'Manual white balance');

    $entry = $ifd0_0->getEntry(41989); // FocalLengthIn35mmFilm
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 67);
    $this->assertEqual($entry->getText(), '67');

    $entry = $ifd0_0->getEntry(41990); // SceneCaptureType
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 0);
    $this->assertEqual($entry->getText(), 'Standard');

    $entry = $ifd0_0->getEntry(41992); // Contrast
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 0);
    $this->assertEqual($entry->getText(), 'Normal');

    $entry = $ifd0_0->getEntry(41993); // Saturation
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 0);
    $this->assertEqual($entry->getText(), 'Normal');

    $entry = $ifd0_0->getEntry(41994); // Sharpness
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 0);
    $this->assertEqual($entry->getText(), 'Normal');

    $entry = $ifd0_0->getEntry(41996); // SubjectDistanceRange
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 1);
    $this->assertEqual($entry->getText(), 'Macro');

    $entry = $ifd0_0->getEntry(42240); // Gamma
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 => 22,
  1 => 10,
));
    $this->assertEqual($entry->getText(), '22/10');

    /* Sub IFDs of $ifd0_0. */
    $this->assertEqual(count($ifd0_0->getSubIfds()), 1);
    $ifd0_0_0 = $ifd0_0->getSubIfd(4); // IFD Interoperability
    $this->assertIsA($ifd0_0_0, 'PelIfd');

    /* Start of IDF $ifd0_0_0. */
    $this->assertEqual(count($ifd0_0_0->getEntries()), 2);

    $entry = $ifd0_0_0->getEntry(1); // InteroperabilityIndex
    $this->assertIsA($entry, 'PelEntryAscii');
    $this->assertEqual($entry->getValue(), 'R03');
    $this->assertEqual($entry->getText(), 'R03');

    $entry = $ifd0_0_0->getEntry(2); // InteroperabilityVersion
    $this->assertIsA($entry, 'PelEntryVersion');
    $this->assertEqual($entry->getValue(), 1);
    $this->assertEqual($entry->getText(), 'Interoperability Version 1.0');

    /* Sub IFDs of $ifd0_0_0. */
    $this->assertEqual(count($ifd0_0_0->getSubIfds()), 0);

    $this->assertEqual($ifd0_0_0->getThumbnailData(), '');

    /* Next IFD. */
    $ifd0_0_1 = $ifd0_0_0->getNextIfd();
    $this->assertNull($ifd0_0_1);
    /* End of IFD $ifd0_0_0. */

    $this->assertEqual($ifd0_0->getThumbnailData(), '');

    /* Next IFD. */
    $ifd0_1 = $ifd0_0->getNextIfd();
    $this->assertNull($ifd0_1);
    /* End of IFD $ifd0_0. */

    $this->assertEqual($ifd0->getThumbnailData(), '');

    /* Next IFD. */
    $ifd1 = $ifd0->getNextIfd();
    $this->assertIsA($ifd1, 'PelIfd');
    /* End of IFD $ifd0. */

    /* Start of IDF $ifd1. */
    $this->assertEqual(count($ifd1->getEntries()), 4);

    $entry = $ifd1->getEntry(259); // Compression
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 6);
    $this->assertEqual($entry->getText(), 'JPEG compression');

    $entry = $ifd1->getEntry(282); // XResolution
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 => 72,
  1 => 1,
));
    $this->assertEqual($entry->getText(), '72/1');

    $entry = $ifd1->getEntry(283); // YResolution
    $this->assertIsA($entry, 'PelEntryRational');
    $this->assertEqual($entry->getValue(), array (
  0 => 72,
  1 => 1,
));
    $this->assertEqual($entry->getText(), '72/1');

    $entry = $ifd1->getEntry(296); // ResolutionUnit
    $this->assertIsA($entry, 'PelEntryShort');
    $this->assertEqual($entry->getValue(), 2);
    $this->assertEqual($entry->getText(), 'Inch');

    /* Sub IFDs of $ifd1. */
    $this->assertEqual(count($ifd1->getSubIfds()), 0);

    $thumb_data = file_get_contents(dirname(__FILE__) .
                                    '/pentax-istDS-thumb.jpg');
    $this->assertEqual($ifd1->getThumbnailData(), $thumb_data);

    /* Next IFD. */
    $ifd2 = $ifd1->getNextIfd();
    $this->assertNull($ifd2);
    /* End of IFD $ifd1. */

    $this->assertTrue(count(Pel::getExceptions()) == 0);

  }
}

?>
