<?php
    require_once('api-adodb/config.php');

    require_once("database.class.php");

    class Sitemap extends TableTraversal{

        var $tablesInOrder = array();
        var $excludedTables = array();

        function __construct($options=null){
            if(isset($options['order'])){
                foreach($options['order'] as $tableName){
                    $this->tablesInOrder[] = $tableName;
                }
            }

            if(isset($options['exclude'])){
                $this->excludedTables = $options['exclude'];
            }
        }

        function getAllSiteTables(){
            global $oneRowTables;
            $table = new Table();
            $allTables = $table->siteMapTables();
            $validTables = array();
            foreach($allTables as $tableName=>$index){
                if(in_array($tableName,$oneRowTables)){
                    continue;
                }

                $validTables[] = $tableName;
            }

            return $validTables;
        }

        /**
        * Returns all valid tables, in the order the user wants them drawn
        *
        */
        function getOrderedTables(){
            $array =  array_unique(array_merge($this->tablesInOrder, $this->getAllSiteTables()));
            $array = array_diff($array,$this->excludedTables);

            return $array;
        }



//        function drawSiteMap($options=null){
//            $validTables = $this->getOrderedTables();

//            foreach($validTables as $tableName){
//                $menu = MenuItem::createMenu($tableName,$options);
//                drawMenu($menu,3);
//            }
//        }

          function drawSiteMap($options=null){
            $validTables = $this->getOrderedTables();

            foreach($validTables as $tableName){
                $menu = TableTraversal::createMenu($tableName,$options);
                drawMenu($menu,3);
            }
        }
    }
?>
