<?php require_once('header.php'); ?>
	
	<script src="https://maps.googleapis.com/maps/api/js?v=3.exp"></script>
	<script type="text/javascript" src="http://google-maps-utility-library-v3.googlecode.com/svn/trunk/infobox/src/infobox.js"></script>
	<script>
		var cityList = [
			['Verdun', 33.878007, 35.500518, 1]
		];

		var boxList =[];
		var map;

		function initialize() {
			map = new google.maps.Map(document.getElementById('map-canvas'), {
				zoom: 7,
				center: new google.maps.LatLng(cityList[0][1], cityList[0][2]),
				mapTypeId: google.maps.MapTypeId.ROADMAP
			});

			addMarkers();
		}

		function addMarkers(){
			for (var i = 0; i < cityList.length; i++)
			{
				marker = new google.maps.Marker({
					position: new google.maps.LatLng(cityList[i][1], cityList[i][2]),
					map: map,
					id: i,
					title: cityList[i][0],
					icon: 'img/ico-map-pin.png'
				});

				var content  = '<div class="map__bubble">';
					content += 'LEBANON <br>ABC DBAYEH <br>LEVEL '+ i +'<br>';
					content += '<a href="#" class="map__more-info">More info</a>';
					content += '</div>';

				var boxText = document.createElement("div");
				boxText.id = i;
				boxText.style.cssText = "height: 100%; background: url(img/bg-stores-map-info.png) no-repeat center center;";
				boxText.innerHTML = content;

				var myOptions = {
					content: boxText,
					disableAutoPan: false,
					maxWidth: 0,
					pixelOffset: new google.maps.Size(-15, -275),
					zIndex: null,
					boxStyle: {
						// background: "url('tipbox.gif') no-repeat",
						width: "183px",
						height: '209px'
					},
					// closeBoxMargin: "10px 2px 2px 2px",
					// closeBoxURL: "http://www.google.com/intl/en_us/mapfiles/close.gif",
					infoBoxClearance: new google.maps.Size(1, 1),
					isHidden: false,
					pane: "floatPane",
					enableEventPropagation: false
				};

				var ib = new InfoBox(myOptions);
				boxList.push(ib);

				google.maps.event.addListener(marker, 'click', (function(marker, i) {
					return function() {
						boxList[i].open(map, this);
					}
				})(marker, i));

				google.maps.event.addDomListener(boxList[i].content_, 'click', (function(marker, i) {
					return function() {
						loadContent(cityList[i][0]);
					}
				})(marker, i));
			} //endfor  
		} //end function

		function loadContent (i)
		{
			$.ajax({
				url: 'map-info.php',
				contentType: 'html',
				success: function(html){
					$('.stores__map').append(html);

					$('.popup--stores').fadeIn();

					$('.slider--stores').slider();
				}
			});
		}

		google.maps.event.addDomListener(window, 'load', initialize);
	</script>
	<div class="content--main">
		<div class="container pure-g">
			<div class="stores__sidebar pure-u-md-1-3 pure-u-1-1">
				<h1 class="title">Stores</h1><br>
				<h2>Our locations</h2><br>
				<h3 class="title">Lebanon</h3>
				<ul class="stores__country-list list--unstyled">
					<li data-list-position="0">Verdun: Dunes center</li>
					<li data-list-position="1">National Museum of Beirut</li>
				</ul>
			</div>
			<div class="stores__map pure-u-md-2-3 pure-u-1-1">
				<div id="map-canvas" style="width: 600px; height: 350px;"></div>
			</div>
		</div>
	</div>

<?php require_once('footer.php'); ?>