// Avoid `console` errors in browsers that lack a console.
(function() {
    var method;
    var noop = function () {};
    var methods = [
        'assert', 'clear', 'count', 'debug', 'dir', 'dirxml', 'error',
        'exception', 'group', 'groupCollapsed', 'groupEnd', 'info', 'log',
        'markTimeline', 'profile', 'profileEnd', 'table', 'time', 'timeEnd',
        'timeline', 'timelineEnd', 'timeStamp', 'trace', 'warn'
    ];
    var length = methods.length;
    var console = (window.console = window.console || {});

    while (length--) {
        method = methods[length];

        // Only stub undefined methods.
        if (!console[method]) {
            console[method] = noop;
        }
    }
}());

// Place any jQuery/helper plugins in here.
$.fn.slider = function(options) {
    var defaults = {
        holder: '.slider__holder', // holder selector
        prev: true, // disable prev button
        prev_class: '.slider__button--prev', // prev button selector
        next: true, // disable next button
        next_class: '.slider__button--next', // next button selector
        nav: true,
        nav_class: '.slider__nav', // navigation holder selector
        speed: 2000, // time between slides in milisec
        auto: false, // auto rotate
        anim_speed: 0.9, // animation speed in seconds, there are 2 animations
    },
        settings = $.extend({}, defaults, options);

    return this.each(function () {
        // Selectors
        var $this = $(this);
        var holder = $this.find(settings.holder); // items holder
        var items = holder.children('li'); // items
        var prev = $this.find(settings.prev_class); // prev arrow
        var next = $this.find(settings.next_class); // next arrow
        var navigation = $this.find(settings.nav_class); // navigation holder

        // numbers
        var items_nb = holder.children('li').length; // Total items
        var active = 0;

        holder.css({
            'width' : 100 * items_nb + '%'
        });
        items.css({
            'width' : 100 / items_nb + '%'
        });

        if (settings.auto) {
            var auto = setInterval(function(){
                showNext();
            }, settings.speed);

            $this.mouseenter(function(){
                clearInterval(auto);
            }).mouseleave(function(){
                auto = setInterval(function(){
                    showNext();
                }, settings.speed);
            });
        };

        if (!settings.nav)
            navigation.hide();

        if (!settings.prev)
            prev.hide();

        if (!settings.next)
            next.hide();

        prev.click(function(e){
            e.preventDefault();

            showPrev();
        });

        next.click(function(e){
            e.preventDefault();

            showNext();
        });

        navigation.children().click(function(e){
            e.preventDefault();

            showClicked($(this).index());
        });

        function showPrev(){
            // Start over if needed
            if(active == 0){
                active = items_nb;
            }

            active--;
            TweenLite.to(holder, settings.anim_speed, {x: -(100 / items_nb * active)+'%', className: '-=active'});

            changeActiveNavigation();
        }

        function showNext(){
            // Start over if needed
            if(active == items_nb - 1){
                active = -1;
            }

            active++;
            TweenLite.to(holder, settings.anim_speed, {x: -(100 / items_nb * active)+'%', className: '-=active'});
            
            changeActiveNavigation();
        }

        function showClicked(show){
            active = show;

            TweenLite.to(holder, settings.anim_speed, {x: -(100 / items_nb * active)+'%', className: '-=active'});
            
            changeActiveNavigation();   
        }

        function changeActiveNavigation(){
            navigation.find('.active').removeClass('active');
            navigation.children().eq(active).addClass('active');
        }
    });
};