jQuery(document).ready(function($){
	$('.slider--home').slider({
		auto: true
	});

	if ($('.slider--about').length) {
		$('.slider--about').slider({
			// nav: false
		});
	}
	if ($('.slider--birthdays').length) {
		$('.slider--birthdays').slider({
			auto: true,
		});
	}

	if ($('.slider--experiences').length) {
		$('.slider--experiences').slider();
	}
	// Bistro gallery
	if ($('.slider--bistro').length) {
		$('.slider--bistro').slider();

		$(document).on('click', '.slider--bistro a', function(e){
			e.preventDefault();

			var img = $(this).data('original-image');

			$('.popup--bistro__image img').attr('src', img);
		});

		$(document).on('click', '.popup__load', function(e){
			e.preventDefault();

			var nb  = $(this).data('image-nb');

			var img = $('.slider--bistro a').eq(nb).data('original-image');
			$('.popup--bistro__image img').attr('src', img);

			$('.popup--bistro').fadeIn();
		});
	}

	// News popup
	if ($('.news').length) {
		$(document).on('click', '.news__item', function(e){
			e.preventDefault();

			$('.popup--news').fadeIn();
		});
	}

	// Popup global
	$(document).on('click', '.popup__close', function(e){
		e.preventDefault();

		$(this).parent().parent().fadeOut();
		if ($(this).parent().parent().hasClass('popup--stores')) {
			$(this).parent().parent().remove();
		}
	});

	// Career form
	if ($('.career__form').length) {
		$(document).on('click', '.career__list li', function(){
			$('.career__list li.active').removeClass('active');
			$(this).addClass('active');
			$('.career__form').fadeIn();
		});
	}

	// Stores click
	$(document).on('click', '.stores__country-list li', function(){
		var index  = $(this).data('list-position');
		var center = new google.maps.LatLng(cityList[index][1], cityList[index][2]);
		loadContent(index);
		map.panTo(center);
	});

	// Shop nav click
	$(document).on('click', '.shop__list-item > a', function(e){
		e.preventDefault();

		$('.shop__list-item--active').removeClass('.shop__list-item--active').children('ul').slideUp();
		$(this).parent().addClass('shop__list-item--active').children('ul').slideDown();
	});

	if ($('.fancybox').length) {
		$('.fancybox').fancybox({
			padding: [100, 23, 80, 23]
		});
	}
});
