<?php require_once('header.php'); ?>

	<div id="profile" class="villages container">
		<div class="wrapper">
			<div class="pure-g">
				<div class="side pure-u pure-u-md-1-5">
					<?php require_once('innermenu-profile.php'); ?>
				</div>
				<div class="main pure-u pure-u-md-4-5">
					<div class="main-heading">
						<img src="img/ico-villages.png" alt="">
						<h3 class="block-title">
							<span>The 7 <br>
							Surrounding Villages</span>
						</h3>
						<h6 class="sans-bold main-description">
							Jabal Moussa is surrounded by 7 main villages: Yahchouch, Qehmez, Jouret el Thermos, Nahr ed Dahab, Ghbale, Aabri, and Chouwan.
						</h6>
					</div>
					<div class="img-container center">
						<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="villages_map" x="0px" y="0px"
	 							width="799.277px" height="297.54px" viewBox="0 0 799.277 297.54">
	 							
								
	 						<a data-slide-index="0" xlink:href="" xlink:title="Al iibré and Chouwan" class="">

								<polygon fill="#558d3f" id="village1" points="504.049,4.581 507.409,10.342 508.609,12.503 509.81,16.824 510.53,18.985 512.93,23.066 
							514.13,26.426 515.57,26.666 515.09,30.987 515.33,34.108 516.05,36.989 516.05,38.189 514.61,40.83 513.89,43.231 513.65,46.111 
							514.13,48.032 514.61,51.873 514.61,53.073 514.37,54.753 513.65,57.394 512.69,58.114 511.49,58.834 510.53,59.795 509.81,61.235 
							509.57,63.155 508.609,64.116 506.449,66.276 505.249,67.236 499.489,70.837 498.528,72.038 496.608,74.918 494.928,76.119 
							493.728,76.599 492.288,77.559 490.368,80.68 487.247,81.16 485.087,81.4 482.207,82.12 480.287,82.36 479.087,82.84 
							477.646,85.241 473.566,85.001 471.166,86.681 469.246,87.401 467.806,91.242 464.445,93.163 461.805,95.083 460.125,96.524 
							459.165,97.244 457.725,98.204 455.324,99.404 452.684,101.085 450.524,102.765 449.084,104.206 448.604,105.406 446.923,108.046 
							445.723,110.927 444.043,110.207 441.883,110.927 440.443,111.887 438.763,113.568 437.323,113.808 435.882,113.808 
							434.202,113.808 432.522,114.048 430.602,115.488 428.922,116.208 427.242,116.449 423.401,116.449 420.281,116.449 
							419.081,115.968 417.161,115.008 414.28,113.088 412.6,112.848 414.28,116.449 414.52,117.409 414.28,119.089 413.56,120.049 
							412.36,120.289 410.2,120.289 408.52,119.809 406.12,119.569 404.439,119.809 403.479,120.289 399.879,121.97 396.999,123.17 
							394.358,124.37 393.398,125.091 392.438,126.531 390.758,126.771 389.798,128.451 388.598,130.852 387.878,131.572 386.198,132.052 
							384.998,132.052 383.317,132.052 381.637,131.572 380.197,131.812 378.997,132.052 377.077,133.013 374.437,133.732 
							372.756,133.732 366.756,130.852 363.875,129.172 359.795,129.172 358.115,128.211 357.635,126.051 355.475,125.091 353.314,123.41 
							351.634,121.49 349.954,118.849 346.354,119.329 341.793,120.53 338.913,121.01 335.793,119.089 334.593,118.849 327.392,113.328 
							325.712,106.126 325.232,104.926 324.752,103.725 324.752,101.565 325.232,94.603 325.232,91.002 324.992,88.602 324.752,85.961 
							324.992,83.32 325.232,80.44 325.472,77.799 326.912,70.357 324.992,69.877 326.672,67.476 327.632,66.276 329.312,64.116 
							330.752,62.435 331.952,60.275 333.153,58.834 334.593,57.154 336.273,55.233 337.233,54.033 337.473,52.833 336.993,51.633 
							336.273,49.472 335.313,47.071 335.073,44.431 333.393,41.55 337.473,40.11 339.633,38.189 341.313,35.549 342.513,34.828 
							346.834,35.069 350.914,35.309 356.195,35.069 359.075,34.108 361.955,33.388 364.356,33.388 367.236,34.348 368.916,34.828 
							371.076,35.069 372.996,34.348 373.476,33.388 373.716,29.787 375.397,28.827 378.757,27.387 392.438,20.185 395.319,19.705 
							399.159,17.784 403.719,19.225 406.12,18.024 407.56,16.824 409,14.904 410.68,13.223 412.6,11.543 414.52,9.622 415.72,8.662 
							418.121,8.662 420.281,9.382 422.921,10.582 432.282,12.983 435.402,12.743 438.283,12.983 442.363,14.423 445.243,15.384 
							448.364,15.864 450.284,15.384 451.484,14.423 453.644,12.263 458.205,13.223 461.085,13.463 465.405,12.983 471.406,11.063 
							479.327,8.182 482.927,6.982 484.847,6.982 487.247,7.702 490.608,8.182 493.488,8.182 495.408,7.222 497.328,6.261 499.489,5.541 
							"/>
							<text x="410" y="75" text-anchor="middle" fill="white" font-size="12">Al iibré and Chouwan</text>
							</a>
							<a data-slide-index="1" xlink:href="" xlink:title="Qehmez" class="">
							<polygon fill="#A7473F" id="village2" points="763.994,56.673 765.674,59.074 765.194,60.994 763.994,61.954 761.594,62.194 760.634,63.155 
							759.194,66.515 758.473,69.156 757.993,73.237 757.993,78.278 757.993,82.119 758.473,83.8 759.674,85.48 767.594,91.241 
							769.274,91.962 757.513,105.885 764.954,109.726 769.034,119.328 771.195,121.249 778.395,126.77 778.155,128.211 778.395,131.811 
							777.675,134.932 775.755,143.094 777.915,147.175 781.756,145.975 783.916,145.015 786.556,142.854 788.716,144.535 
							790.156,144.775 792.077,147.655 795.197,149.336 795.677,151.976 798.317,154.617 798.077,157.738 794.477,159.898 
							791.837,159.898 790.637,160.379 787.996,163.739 782.956,169.261 780.796,171.181 780.076,175.502 779.115,179.583 
							777.195,188.465 774.795,187.745 772.875,187.265 769.755,187.025 766.394,188.225 761.114,188.946 748.632,189.906 
							739.272,190.866 733.751,191.826 732.071,192.546 730.631,193.747 729.431,195.667 728.471,196.387 726.55,197.588 727.991,199.988 
							732.311,198.548 742.632,204.789 740.232,205.75 737.831,206.71 734.711,208.87 731.831,209.591 727.03,210.071 721.75,210.551 
							717.429,210.551 714.069,211.271 709.989,212.711 704.468,215.352 700.868,217.513 696.067,220.633 691.747,224.234 
							687.907,227.595 685.986,228.795 683.826,229.756 678.546,226.875 671.585,223.994 668.705,223.274 663.664,223.274 
							661.504,223.514 659.584,223.994 656.944,225.675 651.423,228.795 649.503,229.516 647.583,229.756 643.502,229.275 
							641.582,229.756 640.622,231.436 633.901,232.156 632.221,232.636 631.021,233.116 628.861,235.037 624.301,238.158 619.26,240.798 
							615.66,241.999 611.579,243.439 610.379,244.399 608.219,246.08 600.538,252.801 596.938,255.682 595.978,256.402 593.578,256.402 
							589.497,256.162 586.137,255.442 581.816,254.002 578.216,252.801 571.735,249.2 568.615,247.76 565.975,246.8 564.055,246.32 
							562.855,246.56 558.294,248.96 552.534,252.561 547.013,255.922 543.173,257.842 535.012,260.963 528.051,264.324 525.891,270.085 
							525.411,271.526 523.971,273.206 521.331,275.367 519.65,276.567 517.25,277.767 516.05,278.488 513.41,280.408 510.049,282.329 
							506.929,283.769 504.049,284.969 502.129,285.929 498.768,288.09 492.528,292.411 489.648,287.85 487.727,285.209 485.807,283.769 
							483.647,280.648 483.407,279.448 483.167,276.567 482.687,272.486 482.687,270.566 482.687,269.125 483.407,267.685 
							486.767,265.284 489.408,263.364 492.528,261.203 497.088,258.803 498.768,258.083 501.169,257.842 503.329,258.083 
							504.769,258.803 506.449,258.803 508.369,259.043 510.53,259.043 513.65,259.523 515.09,258.803 516.77,257.362 518.69,254.242 
							519.65,252.561 520.611,250.161 519.89,248.72 515.09,243.439 513.65,241.759 512.93,240.318 509.569,232.876 508.369,230.476 
							506.209,227.115 505.009,225.915 503.809,223.754 502.849,222.074 501.889,218.713 500.689,217.753 499.008,216.552 
							498.288,215.112 498.288,211.751 498.288,209.351 498.528,207.91 497.808,205.51 497.328,204.549 496.608,203.349 494.928,202.629 
							492.048,202.149 488.207,201.909 486.767,200.948 480.047,196.867 477.886,196.147 475.006,194.467 472.366,193.747 
							470.446,193.507 466.605,193.267 461.565,194.947 459.885,195.907 457.964,196.387 455.564,196.147 452.924,195.667 
							450.524,195.907 448.604,194.947 445.963,194.947 439.483,192.546 441.163,188.225 441.643,186.545 442.363,185.105 
							444.523,183.664 443.803,180.063 443.323,176.462 442.603,173.582 439.963,173.822 438.763,173.102 438.283,171.181 
							438.283,168.781 438.763,167.1 439.723,165.66 443.323,162.539 445.243,160.138 447.884,154.857 449.324,152.457 450.044,149.576 
							450.764,147.895 451.004,143.334 451.244,140.214 451.724,138.293 454.844,136.133 457.964,133.012 459.405,131.331 
							459.885,129.891 459.885,126.53 461.805,124.85 462.285,122.689 463.965,120.769 466.365,117.168 469.726,116.208 471.406,115.247 
							474.766,112.607 476.446,113.087 476.926,111.647 480.767,112.127 483.887,109.006 480.287,104.445 480.047,102.764 
							481.007,100.364 480.527,96.523 479.807,95.323 477.646,94.122 475.246,93.402 467.805,91.241 469.246,87.401 471.166,86.68 
							473.566,85 477.646,85.24 479.087,82.839 480.287,82.359 482.207,82.119 485.087,81.399 487.247,81.159 490.368,80.679 
							492.288,77.558 493.728,76.598 494.928,76.118 496.608,74.917 498.528,72.037 499.488,70.836 505.249,67.236 506.449,66.275 
							508.609,64.115 509.569,63.155 509.809,61.234 510.53,59.794 511.49,58.834 512.69,58.113 513.65,57.393 514.37,54.753 
							514.61,53.072 514.61,51.872 521.091,51.632 524.931,51.152 532.852,49.711 537.892,50.672 540.532,50.912 545.813,49.951 
							553.254,48.991 558.054,49.231 559.734,50.191 560.454,52.352 560.214,54.272 559.734,59.794 559.734,62.194 561.895,66.515 
							563.815,70.596 566.215,78.998 578.456,84.28 580.376,81.639 581.336,80.199 582.777,78.998 585.177,78.038 588.057,77.798 
							592.137,78.518 594.538,80.199 598.138,84.28 600.778,87.881 602.218,89.801 603.899,90.761 606.539,92.682 611.819,95.082 
							615.18,96.523 618.78,97.243 633.661,97.963 639.422,97.963 642.782,96.763 648.063,95.323 659.584,94.842 665.104,96.043 
							671.105,96.043 673.505,97.483 678.306,98.923 679.986,94.602 681.186,92.682 684.066,90.041 687.427,87.881 690.547,86.2 
							696.787,84.28 703.988,83.56 712.149,82.359 715.989,81.879 712.389,77.318 710.709,75.398 709.029,72.997 707.589,71.077 
							700.628,58.834 702.308,57.153 703.748,55.233 705.188,52.112 708.549,50.191 711.429,41.549 711.909,39.869 712.869,38.669 
							715.269,37.228 717.91,36.028 720.31,35.548 722.71,36.028 724.63,37.228 726.79,37.708 728.951,37.468 732.071,36.028 
							738.071,34.588 742.392,33.867 744.072,33.147 745.752,36.748 745.512,42.269 753.433,50.912 757.273,54.272 760.874,56.193 "/>
							<text x="610" y="175" text-anchor="middle" fill="white" font-size="12">Qehmez</text>
							</a>
							<a data-slide-index="2" xlink:href="" xlink:title="Nahr ed Dahab" class="">
							<polygon fill="#A7473F" id="village3" points="464.445,93.163 461.804,95.084 460.124,96.524 459.164,97.244 457.724,98.204 455.323,99.405 
							452.684,101.085 450.524,102.765 449.083,104.205 448.603,105.406 446.923,108.046 445.723,110.927 444.043,110.207 
							441.883,110.927 440.442,111.888 438.763,113.568 437.322,113.808 435.882,113.808 434.201,113.808 432.522,114.048 
							430.601,115.488 428.921,116.208 427.241,116.449 423.4,116.449 420.28,116.449 419.08,115.968 417.16,115.008 414.28,113.087 
							412.6,112.848 414.28,116.449 414.52,117.409 414.28,119.089 413.56,120.05 412.359,120.289 410.199,120.289 408.519,119.809 
							406.119,119.569 404.439,119.809 403.479,120.289 399.878,121.97 396.998,123.17 394.358,124.371 393.398,125.091 392.438,126.53 
							390.757,126.771 389.797,128.451 388.597,130.852 387.877,131.572 386.197,132.052 384.997,132.052 383.317,132.052 
							381.637,131.572 380.197,131.813 378.996,132.052 377.077,133.012 374.436,133.732 372.756,133.732 366.755,130.852 
							363.875,129.172 359.795,129.172 358.114,128.212 357.635,126.051 355.474,125.091 353.314,123.41 351.634,121.49 349.953,118.849 
							346.353,119.329 341.793,120.529 338.913,121.01 335.793,119.089 334.592,118.849 327.391,113.328 325.712,106.126 325.231,104.926 
							324.751,103.725 321.151,104.445 319.471,106.606 318.03,109.486 316.111,112.608 314.43,114.768 312.27,117.409 310.11,119.809 
							303.389,126.771 300.509,130.372 302.909,132.772 298.829,139.254 297.629,140.695 294.748,143.335 292.348,144.296 
							287.308,145.016 283.227,144.775 279.867,144.055 277.947,143.335 274.346,141.174 274.586,143.335 274.107,144.296 
							272.906,144.055 265.225,144.296 261.865,144.055 256.105,144.055 252.744,144.055 251.304,147.416 251.304,148.857 
							252.024,154.858 252.024,157.258 252.024,160.38 251.784,162.06 250.584,163.5 249.144,165.18 247.464,167.101 246.504,167.581 
							244.584,167.581 242.904,167.101 240.263,171.662 239.063,173.342 238.103,174.783 235.943,178.384 235.223,180.304 
							234.742,181.504 234.502,183.185 234.502,184.865 234.742,186.546 234.022,188.466 233.302,189.666 231.622,190.627 
							229.702,190.627 227.542,189.426 219.141,189.666 218.661,188.466 218.181,187.505 215.541,186.306 208.82,184.385 207.62,183.905 
							206.419,182.705 203.78,178.864 203.539,176.943 203.539,175.503 198.5,172.862 197.059,172.142 196.339,170.942 195.139,170.942 
							194.419,172.142 192.739,170.942 189.139,172.142 184.818,168.781 181.697,165.901 180.737,166.621 176.177,163.02 175.936,161.579 
							172.816,160.139 170.177,159.899 167.536,159.66 164.896,159.899 162.976,160.139 162.735,161.579 162.256,166.14 162.256,168.301 
							162.015,169.982 162.496,173.103 162.496,176.223 163.696,178.623 163.936,181.264 164.176,182.224 164.896,183.665 
							165.856,185.105 166.096,189.187 170.417,189.666 169.216,191.827 168.737,193.027 168.016,195.188 167.056,198.548 
							166.336,201.189 165.616,202.869 164.656,206.47 167.536,208.391 168.496,210.552 168.496,212.232 168.256,215.833 168.256,218.953 
							168.016,222.795 168.016,224.955 168.256,228.556 168.256,229.756 168.016,230.957 166.336,232.157 164.656,231.197 
							160.816,232.637 158.895,232.637 157.215,232.877 156.015,233.597 154.335,235.037 153.374,235.997 152.895,237.679 
							152.175,238.638 145.214,241.279 143.294,240.319 141.854,240.799 140.654,241.279 138.253,242.96 136.333,244.64 133.213,246.561 
							132.252,247.281 131.773,248.241 130.573,250.641 129.132,252.322 126.972,254.962 121.692,260.724 122.652,261.684 
							117.851,263.124 115.691,265.285 115.451,266.725 115.211,270.566 115.691,273.447 117.851,274.647 119.291,274.887 
							121.212,274.647 122.891,273.447 130.092,273.927 132.013,273.207 133.933,272.487 138.253,271.286 141.133,270.326 
							144.494,268.886 147.374,267.445 149.534,266.966 151.455,266.725 152.895,266.725 154.575,267.206 155.775,267.206 
							157.695,266.485 160.096,266.005 162.496,266.005 165.136,266.485 167.776,267.445 169.696,268.406 170.896,269.606 
							174.977,272.967 182.898,273.927 185.058,274.408 187.218,274.887 188.419,275.128 189.859,275.848 192.739,275.128 
							193.938,276.327 194.899,277.528 198.019,277.048 199.459,281.61 200.419,284.25 201.62,286.17 203.78,288.81 206.18,290.971 
							208.1,292.411 209.78,292.892 212.18,293.132 211.701,294.572 215.06,295.053 217.461,295.292 219.381,295.532 221.782,295.773 
							226.342,296.972 228.022,294.812 230.182,292.652 235.462,287.611 236.663,286.891 237.863,286.41 240.503,285.93 243.143,286.17 
							249.384,283.049 251.545,284.25 253.224,284.25 254.665,283.529 257.065,282.329 258.025,281.61 259.465,277.528 262.345,276.568 
							263.545,275.607 265.225,273.927 268.346,270.807 274.586,264.565 276.987,264.565 280.107,263.124 282.987,261.684 
							284.908,260.964 287.068,260.964 288.988,256.403 291.628,254.242 293.548,253.282 296.188,252.081 301.949,248.48 304.59,247.04 
							307.949,244.16 309.63,243.68 310.83,239.839 309.63,238.399 310.35,237.679 313.71,237.198 316.111,235.518 321.871,235.518 
							324.751,235.277 326.671,235.037 328.111,235.037 330.511,234.078 331.952,233.357 333.632,232.877 335.552,232.637 
							336.752,232.157 337.233,230.237 337.712,229.036 340.113,228.316 343.233,225.675 344.913,225.195 352.114,222.074 
							353.554,221.354 355.474,221.114 358.594,220.874 360.515,217.754 362.195,216.793 363.875,216.553 365.075,216.313 
							368.195,215.113 375.876,212.712 378.276,212.232 380.436,211.992 381.877,212.232 382.837,212.472 385.957,214.153 
							387.397,215.113 390.278,212.712 391.718,211.752 394.118,210.791 398.678,209.111 401.558,208.151 403.479,207.191 405.159,205.51 
							409,202.869 411.4,201.909 414.04,201.429 417.4,201.429 419.8,201.909 421.72,202.869 422.921,204.79 424.12,206.231 
							424.12,201.67 427.241,201.67 429.641,200.469 432.282,198.789 434.442,196.868 437.322,195.188 439.002,193.747 439.483,192.547 
							441.163,188.226 441.643,186.546 442.363,185.105 444.523,183.665 443.803,180.064 443.323,176.463 442.603,173.582 
							439.962,173.823 438.763,173.103 438.282,171.182 438.282,168.781 438.763,167.101 439.722,165.661 443.323,162.539 
							445.243,160.139 447.883,154.858 449.323,152.458 450.043,149.577 450.763,147.897 451.004,143.335 451.244,140.214 
							451.724,138.293 454.844,136.134 457.964,133.012 459.404,131.332 459.885,129.892 459.885,126.53 461.804,124.85 462.284,122.69 
							463.964,120.77 466.365,117.169 469.725,116.208 471.406,115.248 474.765,112.608 476.446,113.087 476.926,111.647 480.767,112.128 
							483.887,109.007 480.286,104.445 480.047,102.765 481.006,100.365 480.526,96.524 479.806,95.323 477.646,94.123 475.246,93.402 
							467.805,91.242 "/>
							<text x="310" y="195" text-anchor="middle" fill="white" font-size="12">Nahr ed Dahab</text>
							</a>
							<a data-slide-index="3" xlink:href="" xlink:title="Ghbaleh" class="">
							<polygon fill="#A7473F" id="village4" points="125.292,132.292 124.572,133.012 122.652,133.012 120.972,132.052 119.532,130.852 115.931,127.971 
							113.291,129.651 111.371,130.371 109.211,130.612 108.011,130.612 106.091,129.651 103.211,127.491 101.771,129.411 100.57,128.451 
							99.13,129.172 100.81,133.012 102.01,136.133 102.97,138.774 103.45,141.655 103.931,146.936 102.97,148.136 102.73,150.776 
							103.45,152.217 99.61,158.699 99.13,160.379 98.17,161.819 90.729,157.018 87.848,154.858 85.688,153.657 82.328,152.457 
							79.928,152.217 76.087,152.217 76.087,153.897 77.528,155.098 83.528,158.699 75.608,159.419 75.608,160.619 73.448,161.579 
							72.007,165.901 69.847,166.38 67.207,167.82 65.527,168.541 63.606,168.781 60.006,167.341 51.125,168.541 47.045,169.021 
							42.244,169.261 40.324,169.502 41.284,170.701 38.164,172.142 35.764,173.102 34.564,173.582 32.403,174.542 30.483,175.022 
							24.963,175.982 23.042,176.223 19.442,176.223 18.242,176.943 17.042,177.663 15.362,178.143 13.202,178.143 11.282,177.663 
							7.441,176.463 6.001,175.022 3.121,172.622 0.961,173.102 2.88,177.423 5.041,180.544 6.481,182.224 7.681,182.945 10.081,183.904 
							12.002,184.625 14.162,184.865 16.801,184.865 18.962,188.226 19.922,189.426 21.363,193.267 27.363,195.428 29.043,195.908 
							34.324,197.828 33.604,199.989 35.044,200.469 40.084,202.389 42.724,202.389 43.925,202.869 45.845,204.79 47.045,205.27 
							48.725,205.51 49.925,205.99 51.365,208.15 54.006,208.391 55.205,210.311 64.807,210.311 66.967,210.311 70.327,210.791 
							72.967,211.031 75.128,211.751 78.008,212.711 79.207,213.672 80.648,215.833 81.608,217.993 82.088,219.193 82.808,221.834 
							83.769,223.995 86.649,230.716 88.809,234.557 93.369,239.838 97.45,236.957 98.65,237.918 101.771,237.198 104.891,239.359 
							107.771,241.759 109.931,243.68 111.611,245.6 114.491,248.961 117.372,248.72 119.051,248.72 120.492,248.72 120.492,251.601 
							121.212,254.482 120.972,255.682 119.292,258.083 120.972,260.004 121.692,260.724 126.972,254.962 129.132,252.321 
							130.573,250.641 131.773,248.241 132.253,247.28 133.213,246.56 136.333,244.64 138.254,242.96 140.654,241.278 141.854,240.799 
							143.294,240.319 145.214,241.278 152.175,238.638 152.895,237.678 153.375,235.997 154.335,235.037 156.015,233.597 
							157.215,232.877 158.895,232.637 160.816,232.637 164.656,231.197 166.336,232.157 168.017,230.956 168.256,229.756 
							168.256,228.556 168.017,224.955 168.017,222.794 168.256,218.953 168.256,215.833 168.496,212.232 168.496,210.551 
							167.536,208.391 164.656,206.47 165.616,202.869 166.336,201.189 167.056,198.548 168.017,195.188 168.737,193.027 169.216,191.827 
							170.417,189.666 166.096,189.186 165.856,185.105 164.896,183.665 164.176,182.224 163.936,181.264 163.696,178.623 
							162.496,176.223 162.496,173.102 162.016,169.981 162.256,168.301 162.256,166.14 162.736,161.579 162.976,160.139 162.976,157.978 
							162.496,156.298 162.016,154.617 157.936,148.136 157.936,145.976 156.735,144.535 155.775,143.574 154.575,142.854 
							153.135,141.894 150.495,135.893 149.055,136.133 147.615,133.732 145.455,133.972 144.254,132.532 141.854,133.972 
							140.414,134.213 137.053,134.692 135.373,133.732 133.213,132.292 131.533,130.852 129.132,127.251 "/>
							<text x="100" y="195" text-anchor="middle" fill="white" font-size="12">Ghbaleh</text>
							</a>
							<a data-slide-index="4" xlink:href="" xlink:title="Jouret El Termos" class="">
							<polygon fill="#A7473F" id="village5" points="82.808,221.834 83.768,223.995 86.648,230.716 88.809,234.557 93.369,239.838 97.449,236.958 
							98.65,237.918 101.77,237.198 104.89,239.358 107.77,241.759 109.931,243.679 111.611,245.6 114.491,248.961 117.371,248.721 
							119.051,248.721 120.492,248.721 120.492,251.601 121.212,254.482 120.972,255.682 119.292,258.083 120.972,260.003 
							121.692,260.724 122.652,261.684 117.851,263.124 115.691,265.285 115.451,266.725 115.211,270.566 115.691,273.447 
							114.491,273.207 111.851,272.727 108.731,272.727 107.05,272.967 104.89,273.687 103.21,274.407 100.81,273.927 99.61,273.687 
							96.489,273.927 94.329,274.887 89.289,277.768 88.329,278.488 86.648,280.889 83.048,284.489 80.408,282.329 79.448,281.849 
							78.008,281.609 74.887,282.809 72.967,283.529 71.047,283.529 65.766,282.569 65.286,281.369 63.606,278.728 67.927,275.127 
							69.607,274.167 73.687,268.886 73.447,267.445 64.326,268.165 64.086,266.965 62.406,267.205 61.446,263.364 59.526,265.525 
							55.205,265.525 53.525,263.604 53.285,262.164 52.325,260.964 47.285,264.805 45.604,263.124 47.285,260.724 47.765,258.563 
							48.005,255.202 48.485,251.121 51.125,253.282 52.565,253.762 54.725,252.322 53.525,250.161 55.925,248.961 56.165,245.12 
							55.205,243.199 56.885,242.959 58.326,242.479 60.486,241.039 65.286,237.918 72.247,233.117 73.687,232.397 76.327,232.157 
							78.728,232.157 78.008,233.597 81.608,234.557 81.608,230.956 82.808,231.196 83.048,229.276 81.848,226.635 83.288,226.395 
							82.088,223.274 "/>
							<text x="88" y="259" text-anchor="middle" fill="white" font-size="8">
								Jouret El Termos
							</text>
							</a>
							<a data-slide-index="5" xlink:href="" xlink:title="Yahchouch" class="">
							<polygon fill="#A7473F" id="village6"  points="333.392,41.55 335.072,44.431 335.312,47.071 336.272,49.472 336.992,51.632 337.472,52.833 
							337.232,54.033 336.272,55.233 334.592,57.154 333.152,58.834 331.952,60.275 330.752,62.435 329.312,64.116 327.631,66.276 
							326.671,67.476 324.991,69.877 326.911,70.357 325.471,77.799 325.231,80.44 324.991,83.32 324.751,85.961 324.991,88.602 
							325.231,91.002 325.231,94.603 324.751,101.565 324.751,103.725 321.151,104.445 319.471,106.606 318.031,109.487 316.11,112.607 
							314.43,114.768 312.27,117.409 310.11,119.809 303.389,126.771 300.509,130.372 302.909,132.772 298.829,139.254 297.629,140.694 
							294.748,143.335 292.348,144.295 287.308,145.015 283.227,144.775 279.867,144.055 277.947,143.335 274.346,141.175 
							274.586,143.335 274.106,144.295 272.906,144.055 265.225,144.295 261.865,144.055 256.105,144.055 252.744,144.055 
							251.304,147.416 251.304,148.856 252.024,154.858 252.024,157.258 252.024,160.379 251.784,162.06 250.584,163.5 249.144,165.18 
							247.464,167.101 246.504,167.581 244.583,167.581 242.903,167.101 240.263,171.662 239.063,173.342 238.103,174.783 
							235.943,178.384 235.223,180.304 234.743,181.504 234.502,183.185 234.502,184.865 234.743,186.546 234.022,188.466 
							233.302,189.666 231.622,190.627 229.702,190.627 227.542,189.426 219.141,189.666 218.661,188.466 218.181,187.506 
							215.541,186.306 208.82,184.385 207.62,183.905 206.42,182.705 203.78,178.864 203.539,176.943 203.539,175.503 198.499,172.862 
							197.059,172.142 196.339,170.942 195.139,170.942 194.419,172.142 192.738,170.942 189.138,172.142 184.818,168.781 
							181.697,165.901 180.737,166.621 176.177,163.02 175.937,161.58 172.817,160.139 170.176,159.899 167.536,159.659 164.896,159.899 
							162.976,160.139 162.976,157.979 162.496,156.298 162.015,154.618 157.935,148.136 157.935,145.976 156.735,144.535 
							155.775,143.575 154.575,142.855 153.135,141.895 150.494,135.893 149.054,136.133 147.614,133.733 145.454,133.973 
							144.254,132.532 141.854,133.973 140.413,134.213 137.053,134.693 135.373,133.733 133.213,132.292 131.533,130.852 
							129.132,127.251 125.292,132.292 124.572,133.013 122.652,133.013 120.972,132.052 119.531,130.852 115.931,127.971 108.01,121.01 
							107.29,118.369 97.689,109.727 99.129,108.286 101.77,107.326 99.85,103.965 98.409,103.005 96.729,100.845 95.289,100.124 
							93.849,98.444 93.369,96.283 91.449,92.923 90.249,91.722 87.128,88.602 91.689,82.36 94.329,78.759 95.289,77.079 99.129,69.397 
							95.049,66.036 92.889,63.635 90.249,60.995 86.408,57.874 82.568,52.353 81.128,50.912 78.727,49.232 78.968,47.792 78.487,46.591 
							77.767,44.431 76.087,42.27 74.647,40.35 72.967,39.149 70.087,37.469 68.647,36.509 67.206,36.029 63.846,35.068 63.126,31.468 
							60.966,29.067 58.085,25.706 56.645,24.506 54.485,23.306 49.205,19.945 46.564,19.705 45.364,16.824 43.684,15.143 42.484,14.423 
							40.324,13.703 36.003,9.142 32.643,6.501 26.882,1.46 31.923,3.381 38.164,6.261 40.324,7.462 43.924,10.342 45.124,10.822 
							47.044,10.822 52.325,11.303 55.685,11.543 57.845,12.263 68.406,18.264 72.727,21.145 75.847,23.786 76.807,24.746 78.247,24.986 
							81.128,25.226 83.768,25.466 85.928,26.186 87.368,26.666 89.529,26.906 92.169,26.426 93.609,25.706 96.729,22.105 104.17,27.627 
							106.33,27.867 109.93,29.547 113.531,30.987 115.211,31.708 117.611,31.948 121.692,32.188 126.732,39.63 127.932,40.35 
							129.372,41.07 131.773,41.07 134.893,40.35 136.093,40.11 139.693,41.07 143.534,42.75 145.934,43.47 148.574,43.951 
							151.695,43.951 154.575,46.111 157.455,47.792 158.895,48.752 162.976,48.992 165.616,49.472 171.616,50.672 174.257,50.912 
							178.337,50.432 184.338,49.472 186.978,48.752 191.538,48.032 194.179,47.792 196.819,47.551 200.899,47.792 205.22,48.512 
							208.58,48.512 213.38,48.752 215.541,49.232 217.701,49.232 221.061,50.432 223.941,50.432 225.862,50.432 229.222,49.712 
							232.582,49.712 233.782,49.952 236.183,51.152 241.223,53.313 242.903,54.033 246.504,53.793 250.584,52.833 253.224,52.113 
							256.105,50.912 258.025,49.472 260.185,48.272 261.625,47.551 263.785,47.071 266.426,47.071 269.066,47.071 270.986,46.831 
							274.826,45.391 277.947,44.671 280.107,44.431 284.907,44.191 288.028,44.191 290.908,44.671 298.109,43.951 301.229,43.711 
							307.229,41.55 309.39,40.59 311.55,38.429 312.99,37.469 315.63,36.989 318.511,36.269 319.711,36.509 324.511,38.669 
							328.352,40.83 331.712,41.55 "/>
							<text x="210" y="115" text-anchor="middle" fill="white" font-size="12">Yahchouch</text>
							</a>
						</svg>

						<!-- <div class="svg-villages-names">
							<div class="name-1">
								<span>Al iibré and Chouwan</span>
							</div>
							<div class="name-2">
								<span>Qehmez</span>
							</div>
							<div class="name-3">
								<span>Nahr ed Dahab</span>
							</div>
						</div> -->
					</div>
					<ul class="villages-bigslider">
						<li class="item">
							<div class="content pure-g">
								<div class="pure-u pure-u-md-1-2  alpha">
									<div class="padding-lr">

										<h3 class="content-title arrow">
											Al iibré and Chouwan
										</h3>
										<p>
											<b class="green">Governorate:</b> Mount Lebanon <br>
											<b class="green">Caza:</b> Ftouh Kesserwan <br>
											<b class="green">Altitudes:</b> 200m to 1,150m <br>
											<b class="green">Distance from Beirut:</b> 45 Km <br>
											<b class="green">Meaning and origins of the village name:</b> <br>
											1st possibility: Distortion of the word “hāshūsha”, meaning the agonized and tortured.
											2nd possibility: Present form of the verb “hashsh”, meaning suffered and endured.
											3rd possibility: Village of pain and agony.
											4th possibility: Syriac word meaning the “Suffering god”
										</p>
										<p>
											All four possibilities refer to pain and suffering. To explain this, one must go back thousands of years ago, to the times of the Phoenicians, whose god Adonis dies while hunting in the Valley of Adonis River (Nahr Ibrahim), the river that bounds the village of Yahchouch on the North.
										</p>
										<p>
											<b class="green">Touristic sites:</b> <br>
											Two ancient watermills <br>
											Ancient Olive Press <br>
											Monastry: Saint Georges (Mar Geryes), inside Jabal Moussa <br>
											Church: Saint Simon <br>
											Church: Our Lady of Ghochraya  <br>
											Cross of Yahchouch <br>
											One entrance to Jabal Moussa Reserve in Assnawbar, a neighborhood of Yahchouch
										</p>
									</div>
								</div>
								<div class="pure-u pure-u-md-1-2  omega">
									<div class="padding-lr">
										<ul class="village-slider clear-style">
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
										</ul>
									</div>
								</div>
							</div>
						</li>
						<li class="item">
							<div class="content pure-g">
								<div class="pure-u pure-u-md-1-2  alpha">
									<div class="padding-lr">

										<h3 class="content-title arrow">
											Qehmez
										</h3>
										<p>
											<b class="green">Governorate:</b> Mount Lebanon <br>
											<b class="green">Caza:</b> Ftouh Kesserwan <br>
											<b class="green">Altitudes:</b> 200m to 1,150m <br>
											<b class="green">Distance from Beirut:</b> 45 Km <br>
											<b class="green">Meaning and origins of the village name:</b> <br>
											1st possibility: Distortion of the word “hāshūsha”, meaning the agonized and tortured.
											2nd possibility: Present form of the verb “hashsh”, meaning suffered and endured.
											3rd possibility: Village of pain and agony.
											4th possibility: Syriac word meaning the “Suffering god”
										</p>
										<p>
											All four possibilities refer to pain and suffering. To explain this, one must go back thousands of years ago, to the times of the Phoenicians, whose god Adonis dies while hunting in the Valley of Adonis River (Nahr Ibrahim), the river that bounds the village of Yahchouch on the North.
										</p>
										<p>
											<b class="green">Touristic sites:</b> <br>
											Two ancient watermills <br>
											Ancient Olive Press <br>
											Monastry: Saint Georges (Mar Geryes), inside Jabal Moussa <br>
											Church: Saint Simon <br>
											Church: Our Lady of Ghochraya  <br>
											Cross of Yahchouch <br>
											One entrance to Jabal Moussa Reserve in Assnawbar, a neighborhood of Yahchouch
										</p>
									</div>
								</div>
								<div class="pure-u pure-u-md-1-2  omega">
									<div class="padding-lr">
										<ul class="village-slider clear-style">
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
										</ul>
									</div>
								</div>
							</div>
						</li>
						<li class="item">
							<div class="content pure-g">
								<div class="pure-u pure-u-md-1-2  alpha">
									<div class="padding-lr">

										<h3 class="content-title arrow">
											Nahr ed Dahab
										</h3>
										<p>
											<b class="green">Governorate:</b> Mount Lebanon <br>
											<b class="green">Caza:</b> Ftouh Kesserwan <br>
											<b class="green">Altitudes:</b> 200m to 1,150m <br>
											<b class="green">Distance from Beirut:</b> 45 Km <br>
											<b class="green">Meaning and origins of the village name:</b> <br>
											1st possibility: Distortion of the word “hāshūsha”, meaning the agonized and tortured.
											2nd possibility: Present form of the verb “hashsh”, meaning suffered and endured.
											3rd possibility: Village of pain and agony.
											4th possibility: Syriac word meaning the “Suffering god”
										</p>
										<p>
											All four possibilities refer to pain and suffering. To explain this, one must go back thousands of years ago, to the times of the Phoenicians, whose god Adonis dies while hunting in the Valley of Adonis River (Nahr Ibrahim), the river that bounds the village of Yahchouch on the North.
										</p>
										<p>
											<b class="green">Touristic sites:</b> <br>
											Two ancient watermills <br>
											Ancient Olive Press <br>
											Monastry: Saint Georges (Mar Geryes), inside Jabal Moussa <br>
											Church: Saint Simon <br>
											Church: Our Lady of Ghochraya  <br>
											Cross of Yahchouch <br>
											One entrance to Jabal Moussa Reserve in Assnawbar, a neighborhood of Yahchouch
										</p>
									</div>
								</div>
								<div class="pure-u pure-u-md-1-2  omega">
									<div class="padding-lr">
										<ul class="village-slider clear-style">
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
										</ul>
									</div>
								</div>
							</div>
						</li>
						<li class="item">
							<div class="content pure-g">
								<div class="pure-u pure-u-md-1-2  alpha">
									<div class="padding-lr">

										<h3 class="content-title arrow">
											Ghbaleh
										</h3>
										<p>
											<b class="green">Governorate:</b> Mount Lebanon <br>
											<b class="green">Caza:</b> Ftouh Kesserwan <br>
											<b class="green">Altitudes:</b> 200m to 1,150m <br>
											<b class="green">Distance from Beirut:</b> 45 Km <br>
											<b class="green">Meaning and origins of the village name:</b> <br>
											1st possibility: Distortion of the word “hāshūsha”, meaning the agonized and tortured.
											2nd possibility: Present form of the verb “hashsh”, meaning suffered and endured.
											3rd possibility: Village of pain and agony.
											4th possibility: Syriac word meaning the “Suffering god”
										</p>
										<p>
											All four possibilities refer to pain and suffering. To explain this, one must go back thousands of years ago, to the times of the Phoenicians, whose god Adonis dies while hunting in the Valley of Adonis River (Nahr Ibrahim), the river that bounds the village of Yahchouch on the North.
										</p>
										<p>
											<b class="green">Touristic sites:</b> <br>
											Two ancient watermills <br>
											Ancient Olive Press <br>
											Monastry: Saint Georges (Mar Geryes), inside Jabal Moussa <br>
											Church: Saint Simon <br>
											Church: Our Lady of Ghochraya  <br>
											Cross of Yahchouch <br>
											One entrance to Jabal Moussa Reserve in Assnawbar, a neighborhood of Yahchouch
										</p>
									</div>
								</div>
								<div class="pure-u pure-u-md-1-2  omega">
									<div class="padding-lr">
										<ul class="village-slider clear-style">
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
										</ul>
									</div>
								</div>
							</div>
						</li>
						<li class="item">
							<div class="content pure-g">
								<div class="pure-u pure-u-md-1-2  alpha">
									<div class="padding-lr">

										<h3 class="content-title arrow">
											Jouret El Termos
										</h3>
										<p>
											<b class="green">Governorate:</b> Mount Lebanon <br>
											<b class="green">Caza:</b> Ftouh Kesserwan <br>
											<b class="green">Altitudes:</b> 200m to 1,150m <br>
											<b class="green">Distance from Beirut:</b> 45 Km <br>
											<b class="green">Meaning and origins of the village name:</b> <br>
											1st possibility: Distortion of the word “hāshūsha”, meaning the agonized and tortured.
											2nd possibility: Present form of the verb “hashsh”, meaning suffered and endured.
											3rd possibility: Village of pain and agony.
											4th possibility: Syriac word meaning the “Suffering god”
										</p>
										<p>
											All four possibilities refer to pain and suffering. To explain this, one must go back thousands of years ago, to the times of the Phoenicians, whose god Adonis dies while hunting in the Valley of Adonis River (Nahr Ibrahim), the river that bounds the village of Yahchouch on the North.
										</p>
										<p>
											<b class="green">Touristic sites:</b> <br>
											Two ancient watermills <br>
											Ancient Olive Press <br>
											Monastry: Saint Georges (Mar Geryes), inside Jabal Moussa <br>
											Church: Saint Simon <br>
											Church: Our Lady of Ghochraya  <br>
											Cross of Yahchouch <br>
											One entrance to Jabal Moussa Reserve in Assnawbar, a neighborhood of Yahchouch
										</p>
									</div>
								</div>
								<div class="pure-u pure-u-md-1-2  omega">
									<div class="padding-lr">
										<ul class="village-slider clear-style">
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
										</ul>
									</div>
								</div>
							</div>
						</li>
						<li class="item">
							<div class="content pure-g">
								<div class="pure-u pure-u-md-1-2  alpha">
									<div class="padding-lr">

										<h3 class="content-title arrow">
											Yahchouch
										</h3>
										<p>
											<b class="green">Governorate:</b> Mount Lebanon <br>
											<b class="green">Caza:</b> Ftouh Kesserwan <br>
											<b class="green">Altitudes:</b> 200m to 1,150m <br>
											<b class="green">Distance from Beirut:</b> 45 Km <br>
											<b class="green">Meaning and origins of the village name:</b> <br>
											1st possibility: Distortion of the word “hāshūsha”, meaning the agonized and tortured.
											2nd possibility: Present form of the verb “hashsh”, meaning suffered and endured.
											3rd possibility: Village of pain and agony.
											4th possibility: Syriac word meaning the “Suffering god”
										</p>
										<p>
											All four possibilities refer to pain and suffering. To explain this, one must go back thousands of years ago, to the times of the Phoenicians, whose god Adonis dies while hunting in the Valley of Adonis River (Nahr Ibrahim), the river that bounds the village of Yahchouch on the North.
										</p>
										<p>
											<b class="green">Touristic sites:</b> <br>
											Two ancient watermills <br>
											Ancient Olive Press <br>
											Monastry: Saint Georges (Mar Geryes), inside Jabal Moussa <br>
											Church: Saint Simon <br>
											Church: Our Lady of Ghochraya  <br>
											Cross of Yahchouch <br>
											One entrance to Jabal Moussa Reserve in Assnawbar, a neighborhood of Yahchouch
										</p>
									</div>
								</div>
								<div class="pure-u pure-u-md-1-2  omega">
									<div class="padding-lr">
										<ul class="village-slider clear-style">
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
											<li class="item">
												<img src="images/village-pic-1.png" alt="">
											</li>
										</ul>
									</div>
								</div>
							</div>
						</li>
					</ul>
				</div>
			</div>
		</div>
	</div>

<?php require_once('footer.php'); ?>
        