<?php require_once('header.php'); ?>

	<div id="programs" class="tabsoun container">
		<div class="wrapper">
			<div class="pure-g">
				<div class="side pure-u pure-u-md-1-5">
					<?php require_once('innermenu-programs.php'); ?>
				</div>
				<div class="main pure-u pure-u-md-4-5">
					<div class="main-heading">
						<img src="img/tabsoun-icon.png" alt="">
						<h3 class="block-title">
							<span>Tabsoun Tabsoun
								<i class="sans-italic">Because everyone needs a hero!</i>
							</span>
						</h3>
						
					</div>
					<div class="content">
						 <div class="padding-lr pure-g">
						 	<div class="pure-u pure-u-md-1 pure-u-lg-1-2 alpha">
						 		<h3 class="content-title arrow">
						 			Who is Tabsoun?
						 		</h3>
						 		<div class="desc">
						 			<p>
						 				Tabsoun (طبسون) is the Lebanese name for the Rock Hyrax (French: Daman des rochers), a small furry brown animal, unique in its morphology and social life. It is such a particular animal that it is placed in its own order, Hyracoidea, and has its own family, Procaviidae.
						 			</p>
						 			<p>
						 				The rock hyrax has short legs, rounded ears, blunt nose and a rudimentary tail. It is a relatively “chubby” animal, leading to using the Arabic word “Tabsoun” or its verb in this sense. However, do not let its bulk fool you: the rock hyrax can be quite fast and agile when feeling threatened. <br>
										Using its rubbery foot pads, it can climb very steep rocks and trees. <br>
										The rock hyrax occurs in Africa and the Middle East. Its northernmost limit is Lebanon, and particularly Jabal Moussa.
						 			</p>
						 		</div>
						 		<div class="img-container">
						 			<img src="images/tabsoun-pic.png" alt="">
						 		</div>
						 		<h3 class="content-title arrow">
						 			Baby hyraxes!
						 		</h3>
						 		<div class="desc">
						 			<p>
						 				After a long gestation period of 7 to 8 months, a mother hyrax gives birth to 1 to 4 baby hyraxes. Newborns are precocial, being fully developed at birth, and are able to run and jump an hour after birth. <br>
										The young in a colony gather in a nursery group and adult females take turns helping each other attend the little ones.
						 			</p>
						 		</div>
						 		<div class="img-container">
						 			<img src="images/tabsoun2.png" alt="">
						 		</div>
						 		<h3 class="content-title arrow">
						 			Tabsoun Tabsoun: The Book
						 		</h3>
						 		<div class="desc">
						 			<p>
						 				“Tabsoun Tabsoun” is a series of adventure novels for children, written by Najib Kassar, with the “Rock Hyrax” (Tabsoun) as main character and hero. The goal of the series is to raise the awareness of kids on the importance of nature, and to introduce them to the animals and plants in Jabal Moussa Reserve, through an exciting and funny journey with Tabsoun. This initiative is the first worldwide to highlight the Rock Hyrax in the world of children.
						 			</p>
						 			<p>
						 				Tabsoun has grown to become more than just a book. It has become a genuine, successful, awareness raising program that has reached thousands of children so far. Tabsoun is gaining the affection of many kids and is becoming popular in their world. Through this fun, friendly character, they are more appealed to discovering nature. Tabsoun is now considered as the mascot of the Association for the Protection of Jabal Moussa.
						 			</p>
						 			<p>
						 				A large costumed Tabsoun is present in most of Jabal Moussa events and is accompanying APJM team during visits to schools.
						 			</p>
						 			<p>
						 				<span class="red sans-bold">
						 					Some of Tabsoun’s activities:
						 				</span>
						 			</p>
						 			<ul class="clear-style tabsoun-list">
										<li>Interactive presentations to schools</li>
										<li>Distribution of Tabsoun Tabsoun books to school students</li>
										<li>Interactive games and Tabsoun stands</li>
										<li>Presenting the environmental section in the TV show for kids - Kazadoo</li>
						 			</ul>
						 		</div>
						 	</div>
						 	<div class="pure-u pure-u-md-1 pure-u-lg-1-2 omega">
						 		<div class="tabsoun-story">
						 			<div class="pure-g">
						 				<div class="pure-u pure-u-md-1-3 story-item">
						 					<div class="img-container">
						 						<img src="images/phone.png" alt="">
						 					</div>
						 					<div class="text-container">
						 						<p>
							 						For more info about the schools and kids activities 
													<span class="red sans-bold">Call us on: 09-643464</span> or <br>
												</p>
												<span class="red sans-bold">71-944405.</span>
						 					</div>
						 				</div>
						 				<div class="pure-u pure-u-md-1-3 story-item">
						 					<div class="img-container">
						 						<img src="images/play.png" alt="">
						 					</div>
						 					<div class="text-container">
						 						<p>
							 						To listen to the first part of the Tabsoun Story <br>
													<a href="#" class="red sans-bold">Click here</a>
												</p>
						 					</div>
						 				</div>
						 				<div class="pure-u pure-u-md-1-3 story-item">
						 					<div class="img-container">
						 						<img src="images/pen.png" alt="">
						 					</div>
						 					<div class="text-container">
						 						<p>
							 						To have fun coloring these Tabsoun-themed pages<br>
													<a href="#" class="red sans-bold">Click here</a>
												</p>
						 					</div>
						 				</div>
						 				<div class="pure-u pure-u-md-1-3 story-item">
						 					<div class="img-container">
						 						<img src="images/cam.png" alt="">
						 					</div>
						 					<div class="text-container">
						 						<p>
							 						To see pictures of the real Tabsoun in Jabal Moussa<br>
													<a href="#" class="red sans-bold">Click here</a>
												</p>
						 					</div>
						 				</div>
						 				<div class="pure-u pure-u-md-1-3 story-item">
						 					<div class="img-container">
						 						<img src="images/video.png" alt="">
						 					</div>
						 					<div class="text-container">
						 						<p>
							 						To see videos of the real Tabsoun in Jabal Moussa<br>
													<a href="#" class="red sans-bold">Click here</a>
												</p>
						 					</div>
						 				</div>
						 				<div class="pure-u pure-u-md-1-3 story-item">
						 					<div class="img-container">
						 						<img src="images/tab.png" alt="">
						 					</div>
						 					<div class="text-container">
						 						<p>
							 						To see costumed Tabsoun mascot in schools and events 
													<a href="#" class="red sans-bold">Click here</a>
												</p>
						 					</div>
						 				</div>
						 			</div>
						 			<div class="order-the-book story-item">
						 				<div class="img-container">
					 						<img src="images/book.png" alt="">
					 					</div>
					 					<div class="text-container">
											<a href="#" class="red sans-bold">Order The Book</a>
					 					</div>
						 			</div>
						 		</div>
						 		<h3 class="content-title arrow">
						 			Small hyrax and big elephant are cousins!
						 		</h3>
						 		<div class="desc">
						 			<p>
						 				Although small in size, its closest terrestrial relative is the large Elephant. <br>
										They both share many features, one being the teeth: the hyrax, just like the elephant, crops the vegetation with its molars instead of incisors; its two upper incisors grow out and protrude, just like the tusks of the elephants. Surprisingly, they also share the same nail structure: toes of the hyrax have flat, hoof-like nails, like the elephant’s.
						 			</p>
						 		</div>
						 		<h3 class="content-title arrow">
						 			Sun comes first!
						 		</h3>
						 		<div class="desc">
						 			<p>
						 				Rock hyraxes are gregarious, living in colonies of about 50. They are diurnal: they go out in the daytime. They start their day with a sunbathing session that can last for several hours. After being well warmed up, they look for food together. They are herbivorous, their diet comprising of grass and fruits. 
						 			</p>
						 			<p>
						 				While feeding, they form a circle with their head pointing outside of the circle to keep an eye out for predators. The dominant male often stands guard on a high rock. He is the first to call in case of danger, so that others escape to their shelter among the rocks and stand still until the danger has passed.
						 			</p>
						 			<p>
						 				They can spot a predator, such as a jackal or a python, for over 1 Km away, and they detect aerial predators, such as eagles, thanks to a membrane in their pupil, the umbraculum, that shields the eye from the sun, and allows the rock hyrax to stare into the sun, just like the human’s sunglasses.
						 			</p>
						 		</div>
						 		<h3 class="content-title arrow">
						 			Sing it with me!
						 		</h3>
						 		<div class="desc">
						 			<p>
						 				The rock hyrax produces distinctive loud calls. It has more than 20 different vocalizations and can sign complex songs for several minutes, just like birds. 
						 			</p>
						 			<p>
						 				Hyraxes from different regions use different local dialects in their songs. Calls can be used by the guard hyrax to warn the feeding hyraxes in case of danger.
						 			</p>
						 		</div>
						 		<h3 class="content-title arrow">
						 			As old as history!
						 		</h3>
						 		<div class="desc">
						 			<p>
						 				The rock hyrax is mentioned several times in the Bible: for instance, they are mentioned as one of the four things on earth that are little yet exceeding wise, because “the rock hyraxes are a feeble folk, yet they make their houses in the rocks.” (Proverbs 30:26).
						 			</p>
						 			<p>
						 				Surprisingly, Hispania (origin of the modern name Spain), derives from the Phoenician name of the hyrax: “shaphan” (the hidden one). Indeed, some 3,000 years ago, Phoenicians left their homeland and sailed West; they discovered a place with small mammals which they thought were hyraxes, and they called the place “I-shaphan-im” - Island of the Hyrax. The Romans later modified the island’s name to Hispania.
						 			</p>
						 		</div>
						 		<h3 class="content-title arrow">
					 				Scientific Classification
						 		</h3>
						 		<div class="classification pure-g">
						 			<div class="pure-u pure-u-md-1-2">
							 			<table>
							 				<tr>
							 					<td>KINGDOM</td>
							 					<td>Animalia</td>
							 				</tr>
							 				<tr>
							 					<td>PHYLUM</td>
							 					<td>Chordata</td>
							 				</tr>
							 				<tr>
							 					<td>CLASS</td>
							 					<td>Mammalia (Mammals)</td>
							 				</tr>
							 				<tr>
							 					<td>SPECIES</td>
							 					<td>Procavia Capemsis</td>
							 				</tr>
							 			</table>
						 			</div>
						 			<div class="pure-u pure-u-md-1-2">
						 				<table>
							 				<tr>
							 					<td>ORDER </td>
							 					<td>Hyracoidea</td>
							 				</tr>
							 				<tr>
							 					<td>FAMILY</td>
							 					<td>Procaviidae</td>
							 				</tr>
							 				<tr>
							 					<td>GENUS</td>
							 					<td>Procavia</td>
							 				</tr>
							 			</table>
						 			</div>
						 		</div>
						 	</div>
						 </div>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php require_once('footer.php'); ?>
        