<?php require_once('header.php'); ?>

	<div id="profile" class="reserve container">
		<div class="wrapper">
			<div class="pure-g">
				<div class="side pure-u pure-u-md-1-5">
					<?php require_once('innermenu-profile.php'); ?>
				</div>
				<div class="main pure-u pure-u-md-4-5">
					
					<div class="content pure-g">
						<div class="pure-u pure-u-md-1-2 alpha">
							<div class="main-heading">
								<img src="img/ico-reserve.png" alt="">
								<h3 class="block-title">
									<span>The Reserve</span>
								</h3>
								<p class="main-description">
									<b>Jabal Moussa Biosphere Reserve (JMBR)</b> is located in Kesrouan District, Lebanon, on the shoulders of the western slopes of Mount Lebanon Chain (34° 03’ 43.93” N, 35° 46’ 09.84” E), overlooking the Mediterranean Sea to the West. It covers an area of 6500 hectares, at an altitude ranging between 350 meters in the North-West and 1,700 meters to the South-East. Its main villages are: Yahchouch, Qehmez, Jouret el Thermos, Nahr ed Dahab, Ghbale, Aabri, and Chouwan. Jabal Moussa and surrounding villages became part of the UNESCO Network of Biosphere Reserves under the Man and Biosphere (MAB) program in 2009. As part of the MAB program, JMBR addresses human livelihood improvement and nature conservation through combining natural sciences with social sciences, economics and education.
								</p>
								<div class="btn-container">
									<a href="#" class="btn full sans-bold">FOREST MAP</a>
								</div>
							</div>
							
						</div>
						<div class="pure-u pure-u-md-1-2  omega">
							<div class="padding-lr">
								<div class="map">
									<div class="overlay">
										<a href="#" class="google-map">
											<img src="img/ico-locate-us.png" alt="">
											Locate us on
											<span class="large green">Google Maps</span>
										</a>
									</div>
									<iframe src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d26444.919574062067!2d35.78032969008316!3d34.05374709301616!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1shu!2sro!4v1436216954253" width="735" height="452" frameborder="0" style="border:0" allowfullscreen></iframe>
								</div>
							</div>
						</div>
					</div>
					<div class="content pure-g">
						<div class="pure-u pure-u-md-1-2  alpha">
							<div class="padding-lr">
								<h3 class="content-title">
									Cultural heritage 
								</h3>
								<p>
									Discovering JMBR is also discovering the interdependence between humans and nature. Jabal Moussa and its surroundings present spiritual and historical sites, all of them integrated in their natural 
									environment. <br>
									Such sites include: Adonis Valley as the site of death of god Adonis according to Phoenician mythology, Roman Stairs in Mchati and Ghineh, rock carvings by the Emperor Hadrian dating back to the 2nd century AD in Mchati and Broqta where certain types of trees were ordered to be protected, the remains of old houses isolated in the mountain, an abandoned Ottoman settlement comprising a water mill, farms and an olive press by the river in Chouwan, a Byzantine Church that includes a mosaic in Ghineh, the Adonis rock in Ghineh showing the killing of the God Adonis during a hunt, the Mar Geryes Monastery built on the remains of a Roman temple and a cross erected at the mountain summit in 2000 <br>
									<a href="#" class="link">For more information click here</a>
								</p>
							</div>
						</div>
						<div class="pure-u pure-u-md-1-2  omega">
							<div class="padding-lr">
								<h3 class="content-title">
									Natural heritage 
								</h3>
								<p>
									JMBR presents a rich cultural and natural heritage. It is home to at least 727 flora species, out of which 26 are endemic to Lebanon, and 6 to Jabal Moussa. It is also a Global Important Bird Area (IBA), and more than 137 migratory and soaring bird species have been recorded so far. Rare and threatened mammals have found shelter in the rugged mountain, ranging from bats to wolves and hyenas, adding to more than 20 species.
								</p>
							</div>
						</div>
					</div>
					<div class="img-container last">
						<img src="images/img-reserve.png" alt="">
					</div>
				</div>
			</div>
		</div>
	</div>

<?php require_once('footer.php'); ?>
        