<?php require_once('header.php'); ?>

	<div id="programs" class="native-tree container">
		<div class="wrapper">
			<div class="pure-g">
				<div class="side pure-u pure-u-md-1-5">
					<?php require_once('innermenu-programs.php'); ?>
				</div>
				<div class="main pure-u pure-u-md-4-5">
					<div class="main-heading">
						<img src="img/tree-con.png" alt="">
						<h3 class="block-title">
							<span>Tree Nurseries
								<i class="sans-italic">Sowing today, for future harvest</i>
							</span>
						</h3>
						<h6 class="sans-bold main-description">
							APJM maintains three native tree nurseries in 3 villages surrounding Jabal Moussa with a total growing capacity of 40,000 seedlings per year. The trees, well cared for by locals, are grown from seeds collected from the very own trees of Jabal Moussa.
						</h6>
						<h6 class="sans-bold quote">
							"The more one sows, the greater the harvest.”
							<span class="cite sans-italic">- Orison Swett Marden</span>
						</h6>
					</div>
					<div class="content">
						<div class="pure-g padding-lr">
							<div class="pure-u pure-u-md-1-2 alpha">
								<h3 class="content-title arrow">Destiny of our seedlings</h3>
								<div class="desc">
									<p>
										When ready for outplanting, some of the seedlings are planted in degraded sites in Jabal Moussa, through projects <span class="red underline">(TJ Saadeh forest)</span> or by enthusiastic tourists <span class="red">(Plant your tree!).</span><br>
										Our seedlings also serve nationwide reforestation initiatives and thousands of seedlings from the provenance of Jabal Moussa helped reforest sites all over Lebanon. (The most renowned project so far was the Lebanon Reforestation Initiative (LRI) in which overall survival rates of our seedlings reached up to 91%). 
									</p>
								</div>
								<h4 class="content-subtitle green">
									<img src="img/ico-tree-green.png" alt="">
									BUY YOUR TREE!
								</h4>
								<div class="desc">
									<p>
										Plant a tree from Jabal Moussa in your home garden by selecting any one of our beautiful seedlings.
									</p>
								</div>
							</div>
							<div class="pure-u pure-u-md-1-2 omega">
								<h3 class="content-title arrow">How it all started</h3>
								<div class="desc">
									<p>
										Our network of native tree nurseries was launched through the <span class="red underline">Treecon Project</span> funded by UNOPS. The latest collaboration with Lebanon Reforestation Initiative enabled us to enhance the productivity of our nurseries.
									</p>
									<p class="sans-italic">
										“The increased capacity and vitality of APJM’s nursery production will continue to provide, for years to come, high-quality native tree seedlings”. LRI report.
									</p>
								</div>
								<h5 class="red underline nurseries">
									<a href="#">Visit our nurseries</a>
								</h5>
							</div>
						</div>
						<div class="padding-lr">
							<h3 class="content-title arrow">Species planted</h3>
							<div class="spice-tab-heading">
								<a href="#" class="active">Trees and Shrubs</a>
								<a href="#">Plants</a>
							</div>
						</div>
						<div class="plant-list pure-g">
							<?php foreach(range(1,2) as $i): ?>
							<div class="pure-u pure-u-md-1-4 plant-item">
								<div class="img-container">
									<img src="images/img-plants-1.jpg" alt="">
								</div>
								<div class="text-container">
									<h4 class="plant-name sans-bold caps">
										SPECIE1
									</h4>
									<div class="desc">
										<p>
											decription about the specie goes here, it shouldn’t be too big, just about 3 lines not more. <a href="plant.php" class="red">(...)</a>
										</p>
									</div>
								</div>
							</div>
							<div class="pure-u pure-u-md-1-4 plant-item">
								<div class="img-container">
									<img src="images/img-plants-2.jpg" alt="">
								</div>
								<div class="text-container">
									<h4 class="plant-name sans-bold caps">
										SPECIE2
									</h4>
									<div class="desc">
										<p>
											decription about the specie goes here, it shouldn’t be too big, just about 3 lines not more. <a href="plant.php" class="red">(...)</a>
										</p>
									</div>
								</div>
							</div>
							<div class="pure-u pure-u-md-1-4 plant-item">
								<div class="img-container">
									<img src="images/img-plants-3.jpg" alt="">
								</div>
								<div class="text-container">
									<h4 class="plant-name sans-bold caps">
										SPECIE3
									</h4>
									<div class="desc">
										<p>
											decription about the specie goes here, it shouldn’t be too big, just about 3 lines not more. <a href="plant.php" class="red">(...)</a>
										</p>
									</div>
								</div>
							</div>
							<div class="pure-u pure-u-md-1-4 plant-item">
								<div class="img-container">
									<img src="images/img-plants-4.jpg" alt="">
								</div>
								<div class="text-container">
									<h4 class="plant-name sans-bold caps">
										SPECIE4
									</h4>
									<div class="desc">
										<p>
											decription about the specie goes here, it shouldn’t be too big, just about 3 lines not more. <a href="plant.php" class="red">(...)</a>
										</p>
									</div>
								</div>
							</div>
							<?php endforeach; ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php require_once('footer.php'); ?>
        