$(document).ready(function() {
    
    // Hompage slider
    $('.home-slider').bxSlider({
        controls: false,
    });

    // Newsletter popup
    $(document).on('click', '#home .newsletter', function() {
        $('body').addClass('inpopup');
    });
    // Close popup
    $(document).mouseup(function(e) {
        e.preventDefault();
        var sliderContainer = $('.popup-inner');
        var popupClose = $('.close-popup');

        if (!sliderContainer.is(e.target) && sliderContainer.has(e.target).length === 0 || popupClose.is(e.target)) {
            $('body').removeClass('inpopup');
        }
    });

    // Villages mig slider
    $('.villages-bigslider').bxSlider({
        pagerCustom: '#villages_map',
        // mode: 'fade',
        controls: false,
    });

    $('#villages_map a').on('click', function() {
        console.log($(this).attr("xlink:title"));
        $(this).siblings().find('path, polygon, circle').attr('fill', '#a7463f');
        $(this).find('path, polygon, circle').attr('fill', '#558d3f');

    });

    // Village slider
    $('.village-slider').bxSlider({
        pager: false,
    });

    // Menu activator
    // Mobile menu activator
    $('.menu-activator .lines-button').on('click', function() {
        $('.header').toggleClass('menu-on');
        $(this).toggleClass('close');
    });

    // Popup for designation

    $(document).on('click', '.designation-item .link, .job-item a, .cercle-item a, .biography a, .plant-item a, .plant a, .upload-species a, .sponsor-table a', function(e) {
        e.preventDefault();
        var popupContent = $(this).attr('href');
        var windowHeight = $(window).height();
        $.ajax({
            type: 'GET',
            url: popupContent,
            dataType: 'html',
            beforeSend: function() {
                $('.popup .popup-inner').empty();
            },
            success: function(html){

                $('.popup .popup-inner').append(html);
                $('.popup .popup-inner > div').css({
                    'max-height' : windowHeight - 250,
                    'overflow' : 'auto',
                });
                $('body').addClass('inpopup');

                // Input file if changed add class for parent
                $("input:file").on('change', function (){
                    $(this).parent('.file').toggleClass('ready');
                });
            },
            error: function(jqXHR, textStatus, errorThrown){
                console.log(jqXHR);
                console.log(textStatus);
                console.log(errorThrown);
            }
        });
        
    });

    // Popup for newsletter
    $(document).on('click', '.index .newsletter', function(e) {
        e.preventDefault();
        var windowHeight = $(window).height();
        $.ajax({
            type: 'GET',
            url: 'newsletter.php',
            dataType: 'html',
            beforeSend: function() {
                $('.popup .popup-inner').empty();
            },
            success: function(html){

                $('.popup .popup-inner').append(html);
                $('.popup .popup-inner > div').css({
                    'max-height' : windowHeight - 250,
                    'overflow' : 'auto',
                });
                $('body').addClass('inpopup');

                // Input file if changed add class for parent
                $("input:file").on('change', function (){
                    $(this).parent('.file').toggleClass('ready');
                });
            },
            error: function(jqXHR, textStatus, errorThrown){
                console.log(jqXHR);
                console.log(textStatus);
                console.log(errorThrown);
            }
        });
        
    });

    // Input file if changed add class for parent
    $("input:file").on('change', function (){
        $(this).parent('.file').toggleClass('ready');
    });

    // Testimonial slider
    $('.testimonial-slider').bxSlider({
        controls: false,
    });

    // Support donation slider
    $('.donation-slider').bxSlider({
        mode: 'fade',
        pagerCustom: '.accordion-heading',
        // pager: false,
        controls: false,

    });

    // Date picker in Book a Hike page
    $('input.datepicker').Zebra_DatePicker({
        always_visible: $('#zebra_date'),
    });

    // Form wizzard
    $("#book").formToWizard({
        submitButton: 'book_hike'
    });

    $(document).on('click', '.step-commands a', function(e) {
        e.preventDefault();
        
    });
    $(document).on('click', '#step1commands .next', function() {
        $('.custom-select select').customSelect();
    });

    // Send Booking
    $(document).on('click', '#book_hike', function(e) {
        e.preventDefault();
        $(this).parent().addClass('sent');
    });

    // Load more project in the List of all projects page
    $('.all-projects .load').on('click', function(e) {
        e.preventDefault();
        $.ajax({
            type: 'GET',
            url: 'more-project.php',
            dataType: 'html',
            success: function(html){

                $('.sponsor-table tbody').append(html);
            },
            error: function(jqXHR, textStatus, errorThrown){
                console.log(jqXHR);
                console.log(textStatus);
                console.log(errorThrown);
            }
        });
    });

    // fancy box for gallery pages
    $(".fancybox").fancybox({
        openEffect  : 'none',
        closeEffect : 'none',
    });

    $('.select select').customSelect();
    
    function mobileChange(mediaQueryList) {
        //If media query triggered 
        if (mediaQueryList.matches) { 
            
        }
    }
    function desktopsx(mediaQueryList) {
        if (mediaQueryList.matches) {
           
        } 
    }
    function tabletChange(mediaQueryList) {
        if (mediaQueryList.matches) {
            
        }
    }
    function desktop(mediaQueryList) {
        if (mediaQueryList.matches) {
            
        } 
    }

        
    /* MEDIA QUERY TABLET TEST */
    if(Modernizr.mq('only all')){
        // media query for mobile
        var mql = window.matchMedia('(min-width: 320px)');
        mql.addListener(mobileChange);
        mobileChange(mql);

        // media query for tablet
        var mql = window.matchMedia('(min-width: 768px)');
        mql.addListener(tabletChange);
        tabletChange(mql);
        
        // media query for desktop
        var mql = window.matchMedia('(min-width: 1024px)');
        mql.addListener(desktop);
        desktop(mql);

        // media query for desktop < 1280
        var mql = window.matchMedia('(max-width: 1280px)');
        mql.addListener(desktopsx);
        desktopsx(mql);  
    }

});



(function($) {
    $.fn.centerImg = function() {
        return this.each(function() {
            var $this = $(this);
                container = $this.parent(),

                imgWidth = $this.width(),
                imgHeight = $this.height(),
                imgRatio = imgWidth / imgHeight,

                containerWidth = container.width(),
                containerHeight = container.height(),
                containerRatio = containerWidth / containerHeight;


            if (imgRatio >= containerRatio){
                $this.css({
                    height  : 100 + "%", // img height  = container height
                    width   : 'auto',

                    // containerHeight * containerRatio = containerWidth
                    // imgW = contH * imgR
                    // WebkitTransform: 'translate(' + ((containerHeight * imgRatio) -  containerWidth) / 2 * -1 + 'px, 0)',
                    '-webkit-transform' : 'translate(' + ((containerHeight * imgRatio) -  containerWidth) / 2 * -1 + 'px, 0)',
                    '-moz-transform' : 'translate(' + ((containerHeight * imgRatio) -  containerWidth) / 2 * -1 + 'px, 0)',
                    '-ms-transform' : 'translate(' + ((containerHeight * imgRatio) -  containerWidth) / 2 * -1 + 'px, 0)',
                    '-o-transform' : 'translate(' + ((containerHeight * imgRatio) -  containerWidth) / 2 * -1 + 'px, 0)',
                    'transform' : 'translate(' + ((containerHeight * imgRatio) -  containerWidth) / 2 * -1 + 'px, 0)',
                });

            } else {
                $this.css({
                    width   : 100 + "%",
                    height  : 'auto',
                    // WebkitTransform: 'translate(0,' + ((containerWidth / imgRatio) -  containerHeight) / 2 * -1 + 'px)'

                    '-webkit-transform' : 'translate(0,' + ((containerWidth / imgRatio) -  containerHeight) / 2 * -1 + 'px)',
                    '-moz-transform' : 'translate(0,' + ((containerWidth / imgRatio) -  containerHeight) / 2 * -1 + 'px)',
                    '-ms-transform' : 'translate(0,' + ((containerWidth / imgRatio) -  containerHeight) / 2 * -1 + 'px)',
                    '-o-transform' : 'translate(0,' + ((containerWidth / imgRatio) -  containerHeight) / 2 * -1 + 'px)',
                    'transform' : 'translate(0,' + ((containerWidth / imgRatio) -  containerHeight) / 2 * -1 + 'px)',
                });
            }

        });
    }
})(jQuery);