<?php require_once('header.php'); ?>

	<div id="reserve" class="eco container">
		<div class="wrapper">
			<div class="pure-g">
				<div class="side pure-u pure-u-md-1-5">
					<?php require_once('innermenu-reserve.php'); ?>
				</div>
				<div class="main pure-u pure-u-md-4-5">
					<div class="main-heading">
						<img src="img/eco7.png" alt="">
						<h3 class="block-title">
							<span>Ecotourism in Jabal Moussa
								<i class="sans-italic">Inspiring thousands of tourists to care!</i>
							</span>
						</h3>
						<h6 class="sans-bold main-description">
							Jabal Moussa… a true mosaic of nature, culture and impressive landscapes… br
							From dramatic scenic views including the Adonis Valley, and a uniquely rich biodiversity that remains mainly unspoiled, to cultural and historical features, Jabal Moussa is drawing tourists from Lebanon and all over the world. Our major goal is to unveil the incredible richness of our Jabal to as many people as we can without negative impact on its natural wealth.
						</h6>
					</div>
					<div class="content">
						<div class="padding-lr pure-g">
							<div class="pure-u pure-u-md-1-3 pure-u-lg-1-5 eco-item">
								<div class="img-container">
									<a href="#">
										<img src="images/eco1.png" alt="">
									</a>
								</div>
								<div class="text-container">
									<h3 class="content-title green">
										<a href="#">
											How to get there?
										</a>
									</h3>
									<p class="desc">
										Find out how to get to
										Jabal Moussa entrances by
										bus or car.
									</p>
								</div>
							</div>
							<div class="pure-u pure-u-md-1-3 pure-u-lg-1-5 eco-item">
								<div class="img-container">
									<a href="#">
										<img src="images/eco2.png" alt="">
									</a>
								</div>
								<div class="text-container">
									<h3 class="content-title green">
										<a href="#">
											Trails & Facilities
										</a>
									</h3>
									<p class="desc">
										Check our hiking trails and
										choose the perfect one for
										you.
									</p>
								</div>
							</div>
							<div class="pure-u pure-u-md-1-3 pure-u-lg-1-5 eco-item">
								<div class="img-container">
									<a href="#">
										<img src="images/eco3.png" alt="">
									</a>
								</div>
								<div class="text-container">
									<h3 class="content-title green">
										<a href="#">
											Book your Hike
										</a>
									</h3>
									<p class="desc">
										All visits are most welcome,
										but groups are asked to
										kindly book in advance.
									</p>
								</div>
							</div>

							<div class="pure-u pure-u-md-1-3 pure-u-lg-1-5 eco-item">
								<div class="img-container">
									<a href="#">
										<img src="images/eco4.png" alt="">
									</a>
								</div>
								<div class="text-container">
									<h3 class="content-title green">
										<a href="#">
											Lunch &<br>
											Accommodation
										</a>
									</h3>
									<p class="desc">
										Learn where you can eat and sleep at local guesthouses while contributing to the socio-economic progress of the area.
									</p>
								</div>
							</div>
							<div class="pure-u pure-u-md-1-3 pure-u-lg-1-5 eco-item">
								<div class="img-container">
									<a href="#">
										<img src="images/eco5.png" alt="">
									</a>
								</div>
								<div class="text-container">
									<h3 class="content-title green">
										<a href="#">
											Printable Map
										</a>
									</h3>
									<p class="desc">
										Get a printable version of the trails map.
									</p>
								</div>
							</div>
						</div>
						<div class="center">
							<p>
								Whether you’re a first-timer, or a regular hiker, we hope you enjoy your visit to Jabal Moussa and get inspired!
							</p>
							<p class="red sans-bold">
								For additional information, kindly call us on
							</p>
							<a href="" class="red">
								<img src="img/eco6.png" alt="">
								<span>09 643 464
								71  944 405</span>
							</a>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php require_once('footer.php'); ?>
        