<?php require_once('header.php'); ?>

	<div id="profile" class="association container">
		<div class="wrapper">
			<div class="pure-g">
				<div class="side pure-u pure-u-md-1-5">
					<?php require_once('innermenu-profile.php'); ?>
				</div>
				<div class="main pure-u pure-u-md-4-5">
					<div class="main-heading">
						<img src="img/ico-association.png" alt="">
						<h3 class="block-title">
							<span>The Association</span>
						</h3>
						<h6 class="sans-bold main-description">
							The Association for the Protection of Jabal Moussa (APJM), a lebanese non-governmental, not-for-profit Organization, was founded in 2007 by prominent professionals from the region and a few well known public figures who were all driven by the same cause: protecting the rich biodiversity of Jabal Moussa and its cultural heritage from increasing external threats.
						</h6>
					</div>
					<div class="content pure-g">
						<div class="pure-u pure-u-md-1-2  alpha">
							<div class="padding-lr">
								<h3 class="content-title">
									Our Mission
								</h3>
								<p>
									“Our Mission is the conservation of biodiversity and preservation of the cultural heritage in Jabal Moussa Mountain and surrounding villages. Our aim is to achieve sustainable development with the participation of local communities”
								</p>
							</div>
						</div>
						<div class="pure-u pure-u-md-1-2  omega">
							<div class="padding-lr border-left">
								<h3 class="content-title">
									Our Vision
								</h3>
								<p>
									“Jabal Moussa strives to be a well conserved Man and Biosphere (MAB) Reserve supportingsustainable ecotourism, education, research, and socio-economic activities, through effective partnerships with local communities and international stakeholders”
								</p>
							</div>
						</div>
					</div>
					<div class="img-container">
						<img src="images/img-associacion.jpg" alt="">
					</div>

					<div class="content pure-g">
						<div class="pure-u pure-u-md-1-2  alpha">
							<div class="padding-lr">
								<h3 class="content-title">
									Our Goals
								</h3>
								<p class="sans-bold">
									Our goal is to follow basic principles of Seville Strategy for Biosphere Reserves: 
									<a href="http://www.unesco.org/mab/doc/brs/Strategy.pdf" class="sans-italic">http://www.unesco.org/mab/doc/brs/Strategy.pdf</a>
								</p>
								<ul class="arrow-list-item">
									<li>
										[Biosphere Reserves] become theatres for reconciling people and nature; they can bring knowledge of the past to the needs of the future; and they can demonstrate how to overcome the problems of the sectoral nature of our institutions.
									</li>
									<li>
										Communities obtain collective responsibility for their own future and become managers of their own development in an ideal case of socio-economic empowerment.
									</li>
								</ul>
							</div>
						</div>
						<div class="pure-u pure-u-md-1-2  omega">
							<div class="padding-lr border-left">
								<h3 class="content-title">
									Helicopter Approach
								</h3>
								<p>
									At the heart of our philosophy is the conviction that the successful management of Jabal Moussa Biosphere Reserve involves the participation of local communities and adaptation to their needs, guided by world class standards and global organizations. Our constant hovering between local and international makes us stronger.
								</p>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

<?php require_once('footer.php'); ?>
        